package com.envisioniot.sub.client.advancedalert;

import com.envisioniot.sub.client.EnosBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.utils.Constants;

/**
 * @author yuanyuan.xia
 * 告警数据订阅 -> 高级告警
 */
public class AdvancedAlertServiceImpl extends EnosBaseService implements IAdvancedAlertService {

    @Override
    public void subscribe(IAdvancedAlertHandler handler, String subId) throws SubscribeException {
        subscribe(handler, subId, null);
    }

    @Override
    public void subscribe(IAdvancedAlertHandler handler, String subId, String consumerGroup) throws SubscribeException {
        subscribe(handler, subId, consumerGroup, null);
    }

    @Override
    public void subscribe(IAdvancedAlertHandler handler, String subId, String consumerGroup, ConnectionStateListener connectionStateListener) throws SubscribeException {
        if (!subscribed.compareAndSet(false, true)) {
            return;
        }

        this.setMessageListener(new AdvancedAlertMessageListener(handler));
        this.setConnectionStateListener(connectionStateListener);
        this.setSubId(subId);
        this.setConsumerGroup(null == consumerGroup ? Constants.DEFAULT_SUB_CLIENT_CONSUMER_GROUP : consumerGroup);
        this.connect();
    }

    @Override
    public void unsubscribe() throws SubscribeException {
        this.stopSub();
    }
}
