package com.envisioniot.sub.client.caseevent;

import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.google.common.base.Strings;

import java.util.List;

public class CaseEventMessageListener implements MessageListener {
    private IEventHandler eventHandler;

    public CaseEventMessageListener(IEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public IEventHandler getEventHandler() {
        return eventHandler;
    }

    public void setEventHandler(IEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    @Override
    public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        this.eventHandler.eventRead(msg.getValue());
    }

    @Override
    public void onMessages(List<String> patchList) {
        this.eventHandler.eventReads(patchList);
    }
}
