package com.envisioniot.sub.client.caseevent;

import com.envisioniot.sub.client.EnosBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.utils.Constants;

/**
 * device or model event
 */
public class EventServiceImpl extends EnosBaseService implements IEventService {

    @Override
    public void subscribe(IEventHandler eventHandler, String subId) throws SubscribeException {
        subscribe(eventHandler, subId, null);
    }

    @Override
    public void subscribe(IEventHandler eventHandler, String subId, String consumerGroup) throws SubscribeException {
        subscribe(eventHandler, subId, consumerGroup, null);
    }

    @Override
    public void subscribe(IEventHandler eventHandler, String subId, String consumerGroup, ConnectionStateListener connectionStateListener) throws SubscribeException {
        if (!subscribed.compareAndSet(false, true)) {
            return;
        }

        this.setMessageListener(new CaseEventMessageListener(eventHandler));
        this.setConnectionStateListener(connectionStateListener);
        this.setSubId(subId);
        this.setConsumerGroup(null == consumerGroup ? Constants.DEFAULT_SUB_CLIENT_CONSUMER_GROUP : consumerGroup);
        this.connect();
    }

    @Override
    public void unsubscribe() throws SubscribeException {
        this.stopSub();
    }
}
