package com.envisioniot.sub.client.data;

import com.envisioniot.sub.client.ParameterizedTypeImpl;
import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.dto.StreamMessage;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;


/**
 * @author yuanyuan.xia
 */
public class DataMessageListener implements MessageListener {

    private IDataHandler dataHandler;

    private static final Gson GSON = new Gson();

    private static final Logger LOG = LoggerFactory.getLogger(DataMessageListener.class);


    public DataMessageListener(IDataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        StreamMessage message = null;
        try {
            message = GSON.fromJson(msg.getValue(), StreamMessage.class);
        } catch (Exception e) {
            LOG.error("error parsing StreamMessage: " + msg.getValue(), e);
        }
        if (null != message) {
            this.dataHandler.dataRead(message);
        }
    }

    static Type type = new ParameterizedTypeImpl(StreamMessage.class);

    @Override public void onMessages(List<String> patchList) {
//        List<StreamMessage> list = new ArrayList<>();
//        for (String v : patchList) {
//            try {
//                list.add(GSON.fromJson(v, StreamMessage.class));
//            } catch (Exception e) {
//                LOG.error("error parsing StreamMessage: " + v, e);
//            }
//        }
        String ori = String.format("[%s]", String.join(",", patchList));
        List<StreamMessage> list = GSON.fromJson(ori, type);

        if (list == null || list.isEmpty()) {
            return;
        }

        this.dataHandler.dataReads(list);
    }

    public IDataHandler getDataHandler() {
        return dataHandler;
    }

    public void setDataHandler(IDataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }
}
