package com.envisioniot.sub.client.data;

import com.envisioniot.sub.client.EnosBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.utils.Constants;


/**
 * 时序数据订阅 -> 实时通道
 * 时序数据订阅 -> 离线通道
 */
public class DataServiceImpl extends EnosBaseService implements IDataService {

    @Override
    public void subscribe(IDataHandler handler, String subId) throws SubscribeException {
        subscribe(handler, subId, null);
    }

    @Override
    public void subscribe(IDataHandler handler, String subId, String consumerGroup) throws SubscribeException {
        subscribe(handler, subId, consumerGroup, null);
    }

    @Override
    public void subscribe(IDataHandler handler, String subId, String consumerGroup,
                          ConnectionStateListener connectionStateListener) throws SubscribeException {
        if (!subscribed.compareAndSet(false, true)) {
            return;
        }
        this.setMessageListener(new DataMessageListener(handler));
        this.setConnectionStateListener(connectionStateListener);
        this.setSubId(subId);
        this.setConsumerGroup(null == consumerGroup ? Constants.DEFAULT_SUB_CLIENT_CONSUMER_GROUP : consumerGroup);
        this.connect();
    }

    @Override
    public void unsubscribe() throws SubscribeException {
        this.stopSub();
    }
}
