package com.envisioniot.sub.client.event;

import com.envisioniot.sub.client.ParameterizedTypeImpl;
import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.Alert;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * created by jie.jin on 2018/9/3.
 */
public class AlertMessageListener implements MessageListener {

    private static final Gson GSON = new Gson();
    IAlertHandler handler;

    private static final Logger LOG = LoggerFactory.getLogger(AlertMessageListener.class);

    public AlertMessageListener(IAlertHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        Alert alert = null;
        try {
            alert = GSON.fromJson(msg.getValue(), Alert.class);
        } catch (Exception e) {
            LOG.error("error parsing Alert msg: " + msg.getValue(), e);
        }
        if (null != alert) {
            this.handler.alertRead(alert);
        }
    }

    static Type type = new ParameterizedTypeImpl(Alert.class);

    @Override
    public void onMessages(List<String> patchList) {
//        List<Alert> list = new ArrayList<>();
//        for (String v : patchList) {
//            try {
//                list.add(GSON.fromJson(v, Alert.class));
//            } catch (Exception e) {
//                LOG.error("error parsing Alert msg: " + v, e);
//            }
//        }
//        if (list.isEmpty()) {
//            return;
//        }
        String ori = String.format("[%s]", String.join(",", patchList));
        List<Alert> list = GSON.fromJson(ori, type);

        if (list == null || list.isEmpty()) {
            return;
        }
        this.handler.alertReads(list);
    }

    public IAlertHandler getHandler() {
        return handler;
    }

    public void setHandler(IAlertHandler handler) {
        this.handler = handler;
    }
}
