package com.envisioniot.sub.client.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.atomic.AtomicBoolean;

/**
 * @author by jie.jin on 2018/8/8.
 */
public class SubThread extends Thread {

    private final static Logger log = LoggerFactory.getLogger(SubThread.class.getName());

    protected volatile AtomicBoolean closed = new AtomicBoolean(false);

    public SubThread(final String name, boolean daemon) {
        super(name);
        configureThread(name, daemon);
    }

    public SubThread(final String name, Runnable runnable, boolean daemon) {
        super(runnable, name);
        configureThread(name, daemon);
    }

    private void configureThread(final String name, boolean daemon) {
        setDaemon(daemon);
        setUncaughtExceptionHandler(new UncaughtExceptionHandler() {
            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Uncaught exception in thread '{}':", name, e);
            }
        });
    }

    public void enable() {
        this.closed.set(false);
    }

    public void disable() {
        this.closed.set(true);
    }
}