package com.envisioniot.sub.client.internal.netty;

import com.envisioniot.sub.common.generated.Common;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.PackageAnalyser;
import com.envisioniot.sub.common.netty.TransferVer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.util.List;

/**
 * created by jie.jin on 2018/12/24.
 */
public class ClientDecoder extends ByteToMessageDecoder {
    // TODO maxFrameLength + safe skip + fail-fast option (just like LengthFieldBasedFrameDecoder)

    private static final Logger LOG = LoggerFactory.getLogger(ClientDecoder.class);

    SubCategory subCategory;
    public ClientDecoder(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    protected void decode(final ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Common.TransferPkg pkg = PackageAnalyser.parse(in);
        if (pkg == null) {
            return;
        }
        TransferVer.setChannelVer(ctx, pkg);
        int seqId = pkg.getSeqId();

        // ACK_CMD is not only ack, but also heartbeat.
        if (pkg.getCmdId() == PackageAnalyser.ACK_CMD) {
            LOG.info("ack: " + seqId + ": " + ctx.channel().remoteAddress());
            return;
        }

        PackageAnalyser.parseData(true, subCategory, out, pkg);
    }
}
