package com.envisioniot.sub.client.internal.netty;

import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.netty.ChannelWriter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

/**
 * created by jie.jin on 2018/12/24.
 */
public class HeartbeatHandler extends ChannelDuplexHandler {
    public final static boolean IS_BLOCKED = false;
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatHandler.class);

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if(evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent) evt;
            
            // heartbeat
            if(e.state() == IdleState.WRITER_IDLE) {
                if (!IS_BLOCKED) {
                    ChannelWriter.writeToChannel(ctx, SubProto.IdleReq.newBuilder().build());
                    LOG.info("write req idle");
                } else {
                    LOG.info("heartbeat is blocked");
                }
            }

            if(e.state() == IdleState.READER_IDLE) {
                LOG.info("in box, read idle, close self.");
                ctx.close();
            }
        }
    }
}
