package com.envisioniot.sub.client.internal.netty;

import com.envisioniot.sub.common.HashUtil;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.AuthDO;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.ChannelWriter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.util.concurrent.TimeUnit;

import static com.envisioniot.sub.common.utils.Constants.AUTHORIZED_CHANNEL;

/**
 * created by jie.jin on 2018/12/24.
 */
public class KeeperHandler extends ChannelInboundHandlerAdapter {

    private static final Logger LOG = LoggerFactory.getLogger(KeeperHandler.class);

    SubCategory subCategory;
    public KeeperHandler(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {

        LOG.info("channel active: " + ctx.channel().remoteAddress());

        SubClient subClient = SubClientCache.get(subCategory);
        final String subId = subClient.getSubId();
        String accessKey = subClient.getAccessKey();
        String secret = subClient.getSecret();

        AuthDO authDO = new AuthDO(subId, accessKey, secret);

        String sign = HashUtil.signAuth(authDO);

        super.channelActive(ctx);

        ChannelWriter.writeToChannel(
                ctx,
                SubProto.AuthReq.newBuilder()
                        .setAccessKey(subClient.getAccessKey())
                        .setSubId(subId)
                        .setSign(sign)
                        .setSubType(subClient.getSubCategory().getId()).build());
        LOG.info("sending auth info...");
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("channel inactive...");
        Boolean authorizedChannel = ctx.channel().attr(AUTHORIZED_CHANNEL).get();

        try {
            SubClient subClient = SubClientCache.get(subCategory);
            if (null != subClient.getConnectionStateListener()) {
                subClient.getConnectionStateListener().disconnected();
            }
        } catch (Exception e) {
            LOG.warn("fail to execute connection state listener", e);
        }

        if (null != authorizedChannel && !authorizedChannel) {
            LOG.info("auth failed, Client will be closed");
            SubClientCache.get(subCategory).shutdownGracefully();
            return;
        }

        if (null == authorizedChannel) {
            LOG.warn("no auth rsp returned, continue retry");
        }

        new Thread() {
            @Override
            public void run() {
                try {
                    TimeUnit.SECONDS.sleep(5);
                } catch (InterruptedException e) {
                    LOG.error("Thread Interrupted", e);
                }

                LOG.info("reconnect sub client.");
                SubClient subClient = SubClientCache.get(subCategory);
                subClient.connect();
            }
        }.start();
        super.channelInactive(ctx);
    }
}
