package com.envisioniot.sub.client.internal.netty;

import com.envisioniot.sub.common.exception.SubscribeException;
import com.envisioniot.sub.common.model.SubCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lixiangxin
 * @date 2021/4/13 20:23
 **/
public class SubClientCache {
    private static final Map<SubCategory, SubClient> CACHE_SUB_CLIENT = new ConcurrentHashMap<>();

    public static SubClient get(SubCategory subCategory) {
        SubClient subClient = CACHE_SUB_CLIENT.get(subCategory);
        if (subClient == null) {
            throw new RuntimeException(new SubscribeException("get null from cache for category " + subCategory
                    .toString()));
        }

        return subClient;
    }

    public static void put(SubCategory subCategory, SubClient subClient) {
        synchronized (CACHE_SUB_CLIENT) {
            if (CACHE_SUB_CLIENT.containsKey(subCategory)) {
                throw new RuntimeException(new SubscribeException("one JVM support at most one same subscription category."));
            }

            CACHE_SUB_CLIENT.put(subCategory, subClient);
        }
    }

    public static Map<SubCategory, SubClient> getCacheSubClient() {
        return CACHE_SUB_CLIENT;
    }
}
