package com.envisioniot.sub.client.internal.netty;

import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.BackingHandler;
import com.envisioniot.sub.common.netty.PbHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.timeout.IdleStateHandler;

import java.util.concurrent.TimeUnit;

/**
 * created by jie.jin on 2018/12/24.
 */
public class SubClientChannelInitializer extends ChannelInitializer<SocketChannel> {

    SubCategory subCategory;
    public SubClientChannelInitializer(SubCategory subCategory, boolean useSSL) {
        this.subCategory = subCategory;
    }
    
    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new IdleStateHandler(120, 60, 0, TimeUnit.SECONDS));
        pipeline.addLast(new ClientEncoder(subCategory));
        pipeline.addLast(new KeeperHandler(subCategory));
        pipeline.addLast(new HeartbeatHandler());
        pipeline.addLast(new ClientDecoder(subCategory));
        pipeline.addLast(new PbHandler(subCategory));
        pipeline.addLast(new BackingHandler());
    }
}
