package com.envisioniot.sub.client.internal.netty.processor;

import com.envisioniot.sub.client.internal.netty.SubClient;
import com.envisioniot.sub.client.internal.netty.SubClientCache;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.ChannelWriter;
import com.envisioniot.sub.common.netty.IProtoProcessor;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.net.InetSocketAddress;

import static com.envisioniot.sub.common.utils.Constants.AUTHORIZED_CHANNEL;


public class AuthRspProcessor implements IProtoProcessor<SubProto.AuthRsp> {

    private static final int SUCCESS_ACK = 0;
    private static final Logger LOG = LoggerFactory.getLogger(AuthRspProcessor.class);

    SubCategory subCategory;
    public AuthRspProcessor(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    public void receive(ChannelHandlerContext ctx, SubProto.AuthRsp msg) {
        LOG.info("receive auth rsp from server: " + msg);
        if (SUCCESS_ACK != msg.getAck()) {
            LOG.error("auth failed. reason: " + msg.getMsg());
            ctx.channel().attr(AUTHORIZED_CHANNEL).set(false);
            ctx.close();
            return;
        }
        ctx.channel().attr(AUTHORIZED_CHANNEL).set(true);
        sendSubRequest(ctx);
    }

    private void sendSubRequest(ChannelHandlerContext ctx) {
        InetSocketAddress localAddress = (InetSocketAddress) ctx.channel().localAddress();

        SubClient subClient = SubClientCache.get(subCategory);
        SubProto.SubReq req = SubProto.SubReq.newBuilder()
                .setCategory(subClient.getSubCategory().getId())
                .setAccessKey(subClient.getAccessKey())
                .setSubId(subClient.getSubId())
                .setClientId(localAddress.getHostName() + "/" + localAddress.getPort())
                .setConsumerGroup(subClient.getConsumerGroup()).build();
        ChannelWriter.writeToChannel(ctx, req);
    }
}
