package com.envisioniot.sub.client.internal.netty.processor;

import com.envisioniot.sub.client.internal.RequestFuture;
import com.envisioniot.sub.client.internal.netty.SubClient;
import com.envisioniot.sub.client.internal.netty.SubClientCache;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.IProtoProcessor;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

import java.util.Iterator;

public class PullRspProcessor implements IProtoProcessor<SubProto.PullRsp> {

    private static final Logger LOG = LoggerFactory.getLogger(PullRspProcessor.class);

    SubCategory subCategory;
    public PullRspProcessor(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    public void receive(ChannelHandlerContext ctx, SubProto.PullRsp rsp) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("receive pull rsp from server: " + rsp);
        }

        SubClient subClient = SubClientCache.get(subCategory);
        synchronized (subClient.getFiredRequests()) {
            Iterator<RequestFuture> itr = subClient.getFiredRequests().iterator();
            while (itr.hasNext()) {
                RequestFuture rf = itr.next();
                if (rf.getId() == rsp.getId()) {
                    rf.complete(rsp);
                } else if (rf.getId() < rsp.getId()) {
                    if (!rf.succeeded()) {
                        LOG.debug("remove expired on flight request: " + rf.getId()+ ", rsp id: " + rsp.getId());
                        itr.remove();
                    }
                } else {
                    break;
                }
            }
        }
    }
}
