package com.envisioniot.sub.client.internal.netty.processor;

import com.envisioniot.sub.client.internal.netty.SubClientCache;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.netty.IProtoProcessor;
import io.netty.channel.ChannelHandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class SubRspProcessor implements IProtoProcessor<SubProto.SubRsp> {

    private static final int SUCCESS_ACK = 0;
    private static final Logger LOG = LoggerFactory.getLogger(SubRspProcessor.class);


    SubCategory subCategory;

    public SubRspProcessor(SubCategory subCategory) {
        this.subCategory = subCategory;
    }

    @Override
    public void receive(ChannelHandlerContext ctx, SubProto.SubRsp rsp) {
        LOG.info("receive sub rsp from server: " + rsp);
        if (SUCCESS_ACK != rsp.getAck()) {
            LOG.error("sub create failed. reason: " + rsp.getMsg());
            ctx.close();
            return;
        }
        boolean batch = SubClientCache.get(subCategory).isBatch();
        LOG.info("auth success, start pull data [{}] from server...", batch ? "batch" : "single");
        startPull(ctx);
    }

    private void startPull(ChannelHandlerContext ctx) {
        SubClientCache.get(subCategory).startPull(ctx);
    }
}
