package com.envisioniot.sub.client.newdata;

import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.google.common.base.Strings;

import java.util.List;


/**
 * NewDataServiceImpl
 *
 * @author yuanyuan.xia
 */
public class NewDataMessageListener implements MessageListener {

    private INewDataHandler dataHandler;

    public NewDataMessageListener(INewDataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    @Override
    public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        this.dataHandler.dataRead(msg.getValue());
    }

    @Override
    public void onMessages(List<String> patchList) {
        this.dataHandler.dataReads(patchList);
    }

    public INewDataHandler getDataHandler() {
        return dataHandler;
    }

    public void setDataHandler(INewDataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }
}
