package com.envisioniot.sub.client.newdata;

import com.envisioniot.sub.client.EnosBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.utils.Constants;


/**
 * @author xiangxin.li
 * 2021-11-9 15:47:27
 */
public class NewDataServiceImpl extends EnosBaseService implements INewDataService {

    @Override
    public void subscribe(INewDataHandler handler, String subId) {
        subscribe(handler, subId, null);
    }

    @Override
    public void subscribe(INewDataHandler handler, String subId, String consumerGroup) {
        subscribe(handler, subId, consumerGroup, null);
    }

    @Override
    public void subscribe(INewDataHandler handler, String subId, String consumerGroup, ConnectionStateListener connectionStateListener) {
        if (!subscribed.compareAndSet(false, true)) {
            return;
        }
        this.setMessageListener(new NewDataMessageListener(handler));
        this.setConnectionStateListener(connectionStateListener);
        this.setSubId(subId);
        this.setConsumerGroup(null == consumerGroup ? Constants.DEFAULT_SUB_CLIENT_CONSUMER_GROUP : consumerGroup);
        this.connect();
    }

    @Override
    public void unsubscribe() {
       this.stopSub();
    }
}
