package com.envisioniot.sub.client.report;

import com.envisioniot.sub.common.model.report.EventValue;
import com.envisioniot.sub.common.model.report.PayloadBean;
import com.envisioniot.sub.common.model.report.Report;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.LinkedTreeMap;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author lixiangxin
 * @date 2021/4/20 15:53
 **/
public class ReportMapTypeAdapter extends TypeAdapter<Object> {

    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory() {
        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            return (TypeAdapter<T>) new ReportMapTypeAdapter();
        }
    };

    @Override
    public void write(JsonWriter jsonWriter, Object o) {

    }

    @Override
    public Object read(JsonReader in) throws IOException {
        Report data = new Report();
        Map<String, Object> dataMap = (Map<String, Object>) readInternal(in);

        if (dataMap.containsKey("orgId")) {
            data.setOrgId((String) dataMap.get("orgId"));
        }

        if (dataMap.containsKey("modelId")) {
            data.setModelId((String) dataMap.get("modelId"));
        }
        if (dataMap.containsKey("modelIdPath")) {
            data.setModelIdPath((String) dataMap.get("modelIdPath"));
        }

        if (!dataMap.containsKey("payload")) {
            return data;
        }

        List<Map<String, Object>> payloads = (List<Map<String, Object>>) dataMap.get("payload");
        if (payloads == null || payloads.isEmpty()) {
            return data;
        }

        ArrayList<PayloadBean> arrayList = new ArrayList<>();
        for (Map<String, Object> payload : payloads) {
            PayloadBean payloadBean = new PayloadBean();

            if (payload.containsKey("assetId")) {
                payloadBean.setAssetId((String) payload.get("assetId"));
            }

            if (payload.containsKey("time")) {
                payloadBean.setTime(Long.parseLong(payload.get("time").toString()));
            }

            Object eventsOri = payload.get("events");
            if (!payload.containsKey("events") || eventsOri == null) {
                arrayList.add(payloadBean);
                continue;
            }

            Set<Map.Entry<String, Object>> entrySet = ((Map<String, Object>) eventsOri).entrySet();
            if (entrySet.isEmpty()){
                arrayList.add(payloadBean);
                continue;
            }

            Map<String, EventValue> events = new HashMap<>(entrySet.size());
            for (Map.Entry<String, Object> es : entrySet) {
                EventValue eventValue = new EventValue();
                Map<String, Object> ev = (Map<String, Object>) es.getValue();

                if (ev.containsKey("outputData")) {
                    eventValue.setOutputData((Map) ev.get("outputData"));
                }

                if (ev.containsKey("eventName")) {
                    eventValue.setEventName((Map) ev.get("eventName"));
                }

                if (ev.containsKey("outputNames")) {
                    eventValue.setOutputNames((Map) ev.get("outputNames"));
                }

                if (ev.containsKey("extraData")) {
                    eventValue.setExtraData((Map) ev.get("extraData"));
                }

                if (ev.containsKey("type")) {
                    eventValue.setType((String) ev.get("type"));
                }

                if (ev.containsKey("eventId")) {
                    eventValue.setEventId((String) ev.get("eventId"));
                }

                events.put(es.getKey(), eventValue);
            }
            payloadBean.setEvents(events);

            arrayList.add(payloadBean);
        }

        data.setPayload(arrayList);

        return data;
    }

    public Object readInternal(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        switch (token) {
            case BEGIN_ARRAY:
                List<Object> list = new ArrayList<>();
                in.beginArray();
                while (in.hasNext()) {
                    list.add(readInternal(in));
                }
                in.endArray();
                return list;

            case BEGIN_OBJECT:
                Map<String, Object> map = new LinkedTreeMap<>();
                in.beginObject();
                while (in.hasNext()) {
                    map.put(in.nextName(), readInternal(in));
                }
                in.endObject();
                return map;

            case STRING:
                return in.nextString();

            case NUMBER:
                /*
                 * Rewrite the digital processing logic and divide the digital value into integer and floating-point types.
                 */
                String numberStr = in.nextString();
                try {
                    if (numberStr.contains(".") || numberStr.contains("e")
                            || numberStr.contains("E")) {
                        return Double.parseDouble(numberStr);
                    }
                    try {
                        return Integer.parseInt(numberStr);
                    } catch (NumberFormatException e) {
                        return Long.parseLong(numberStr);
                    }
                } catch (NumberFormatException e) {
                    return new BigDecimal(numberStr);
                }
            case BOOLEAN:
                return in.nextBoolean();

            case NULL:
                in.nextNull();
                return null;

            default:
                throw new IllegalStateException("unknown data type.");
        }
    }
}
