package com.envisioniot.sub.client.report;

import com.envisioniot.sub.client.ParameterizedTypeImpl;
import com.envisioniot.sub.client.internal.MessageListener;
import com.envisioniot.sub.common.generated.SubProto;
import com.envisioniot.sub.common.model.dto.StreamMessage;
import com.envisioniot.sub.common.model.report.Report;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

/**
 * created by lixiangxin on 2021/4/12.
 */
public class ReportMessageListener implements MessageListener {

    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory(ReportMapTypeAdapter.FACTORY)
            .create();
    IReportHandler handler;

    private static final Logger LOG = LoggerFactory.getLogger(ReportMessageListener.class);

    public ReportMessageListener(IReportHandler handler) {
        this.handler = handler;
    }

    @Override
    public void onMessage(SubProto.Message msg) {
        if (null == msg || Strings.isNullOrEmpty(msg.getValue())) {
            return;
        }
        Report report = null;
        try {
            report = GSON.fromJson(msg.getValue(), Report.class);
        } catch (Exception e) {
            LOG.error("error parsing Report msg: " + msg.getValue(), e);
        }
        if (null != report) {
            this.handler.eventRead(report);
        }
    }

    static Type type = new ParameterizedTypeImpl(Report.class);

    @Override
    public void onMessages(List<String> patchList) {
        List<Report> list = new ArrayList<>();
        for (String v : patchList) {
            try {
                list.add(GSON.fromJson(v, Report.class));
            } catch (Exception e) {
                LOG.error("error parsing Report msg: " + v, e);
            }
        }
        if (list.isEmpty()) {
            return;
        }
        this.handler.eventReads(list);
    }

    public IReportHandler getHandler() {
        return handler;
    }

    public void setHandler(IReportHandler handler) {
        this.handler = handler;
    }
}
