package com.envisioniot.sub.client.report;

import com.envisioniot.sub.client.EnosBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;
import com.envisioniot.sub.common.model.SubCategory;
import com.envisioniot.sub.common.utils.Constants;

/**
 * @author lixiangxin
 * @date 2021/4/12 17:03
 * 设备管理系统事件订阅
 **/
public class ReportServiceImpl extends EnosBaseService implements IReportService {

    @Override
    public void subscribe(IReportHandler handler, String subId) throws SubscribeException {
        subscribe(handler, subId, null);
    }

    @Override
    public void subscribe(IReportHandler handler, String subId, String consumerGroup) throws SubscribeException {
        subscribe(handler, subId, consumerGroup, null);
    }

    @Override
    public void subscribe(IReportHandler handler, String subId, String consumerGroup,
                          ConnectionStateListener connectionStateListener) throws SubscribeException {
        if (!subscribed.compareAndSet(false, true)) {
            return;
        }

        this.setMessageListener(new ReportMessageListener(handler));
        this.setConnectionStateListener(connectionStateListener);
        this.setSubId(subId);
        this.setConsumerGroup(null == consumerGroup ? Constants.DEFAULT_SUB_CLIENT_CONSUMER_GROUP : consumerGroup);
        this.connect();
    }

    @Override
    public void unsubscribe() {
        this.stopSub();
    }
}
