#!/bin/sh

source /etc/profile
export LANG="en_US.UTF-8"

CURR_DIR=`pwd`
cd `dirname "$0"`
WORK_HOME=`pwd`
echo "Work Home: ${WORK_HOME}"
CLASS_PATH="$1"
echo "Class Path: ${CLASS_PATH}"
CLASS_NAME="$2"
echo "Class Name: ${CLASS_NAME}"

#set Argu
ARGU_OPTS="-DHOME=${WORK_HOME} -Dskip_upgrade=no"

# define JAVA_OPTS
if [ -z "$JAVA_OPTS" ]; then
    JAVA_OPTS="-Xmx400M -Xms400M"
fi
JAVA_OPTS="$JAVA_OPTS -XX:+UseG1GC -XX:MaxGCPauseMillis=100"
JAVA_OPTS="$JAVA_OPTS -XX:+ParallelRefProcEnabled"
JAVA_OPTS="$JAVA_OPTS -XX:ErrorFile=../logs/hs_err_pid%p.log  -XX:HeapDumpPath=../logs -XX:+HeapDumpOnOutOfMemoryError"
echo "JAVA_OPTS: ${JAVA_OPTS}"


RUN_CMD="java ${ARGU_OPTS} "
RUN_CMD="$RUN_CMD $JAVA_OPTS"
RUN_CMD="$RUN_CMD -cp $@ &"
echo $RUN_CMD
eval $RUN_CMD
#==========================================================================
