package com.envisioniot.sub.client;

import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.model.SubCategory;


/**
 * created by xiangxin.li on 2021/4/25.
 */
public abstract class BaseService {

    protected String host;
    protected int port;
    protected String accessKey;
    protected String accessSecret;
    protected String subId;
    protected SubCategory category;
    protected String consumerGroup;
    protected ConnectionStateListener connectionStateListener;
    protected int requestTimeout = 0;
    protected Object[] options;

    protected boolean isBatch = false;

    public BaseService() {
    }

    void init(SubCategory category,
              String host,
              int port,
              String accessKey,
              String accessSecret) {
        this.category = category;
        this.host = host;
        this.port = port;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
    }

    void init(SubCategory category,
              String host,
              int port,
              String accessKey,
              String accessSecret, boolean isBatch) {
        this.category = category;
        this.host = host;
        this.port = port;
        this.accessKey = accessKey;
        this.accessSecret = accessSecret;
        this.isBatch = isBatch;
    }

    public SubCategory getCategory() {
        return category;
    }

    public void setCategory(SubCategory category) {
        this.category = category;
    }

    public String getConsumerGroup() {
        return consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }


    public ConnectionStateListener getConnectionStateListener() {
        return connectionStateListener;
    }

    public void setConnectionStateListener(ConnectionStateListener connectionStateListener) {
        this.connectionStateListener = connectionStateListener;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getAccessSecret() {
        return accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this.accessSecret = accessSecret;
    }

    public String getSubId() {
        return subId;
    }

    public void setSubId(String subId) {
        this.subId = subId;
    }

    public void setRequestTimeout(int timeout) {
        this.requestTimeout = timeout;
    }

    public Object[] getOptions() {
        return options;
    }

    public void setOptions(Object[] options) {
        this.options = options;
    }
}
