package com.envisioniot.sub.client.advancedalert;

import com.envisioniot.sub.client.IBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;


public interface IAdvancedAlertService extends IBaseService {
    /**
     * subscribe advanced alert with default consumer group
     *
     * @param handler sub message callback
     * @param subId   sub id
     * @throws SubscribeException subscribe exception
     */
    void subscribe(IAdvancedAlertHandler handler, String subId) throws SubscribeException;

    /**
     * subscribe advanced alert with specific consumer group
     *
     * @param handler       sub message callback
     * @param subId         sub id
     * @param consumerGroup consumerGroup this subscription
     * @throws SubscribeException subscribe exception
     */

    void subscribe(IAdvancedAlertHandler handler, String subId, String consumerGroup) throws SubscribeException;

    /**
     * subscribe advanced alert with specific consumer group and connection state listener
     *
     * @param handler                 sub message callback
     * @param subId                   sub id
     * @param consumerGroup           consumerGroup this subscription
     * @param connectionStateListener connection state listener
     * @throws SubscribeException subscribe exception
     */
    void subscribe(IAdvancedAlertHandler handler, String subId, String consumerGroup, ConnectionStateListener connectionStateListener) throws SubscribeException;

    /**
     * unsubscribe alert sub.
     *
     * @throws SubscribeException subscribe exception
     */
    void unsubscribe() throws SubscribeException;
}
