package com.envisioniot.sub.client.event;

import com.envisioniot.sub.client.IBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;

public interface IAlertService extends IBaseService {
    /**
     * @param handler
     * @param subId
     * @throws SubscribeException
     */
    void subscribe(IAlertHandler handler, String subId) throws SubscribeException;

    /**
     *
     * @param handler sub message callback
     * @param subId sub id
     * @param consumerGroup consumerGroup this subscription
     * @throws SubscribeException
     */

    void subscribe(IAlertHandler handler, String subId, String consumerGroup) throws SubscribeException;

    void subscribe(IAlertHandler handler, String subId, String consumerGroup, ConnectionStateListener connectionStateListener) throws SubscribeException;

    /**
     * unsubscribe alert sub.
     *
     * @throws SubscribeException
     */
    void unsubscribe() throws SubscribeException;
}
