package com.envisioniot.sub.client.newdata;

import com.envisioniot.sub.client.IBaseService;
import com.envisioniot.sub.client.internal.ConnectionStateListener;
import com.envisioniot.sub.common.exception.SubscribeException;

public interface INewDataService extends IBaseService {


    /**
     * register data subscription
     *
     * @param handler
     * @param subId
     * @throws SubscribeException
     */
    void subscribe(INewDataHandler handler, String subId) throws SubscribeException;

    /**
     * register data subscription with consumerGroup
     *
     * @param handler
     * @param subId
     * @param consumerGroup
     * @throws SubscribeException
     */
    void subscribe(INewDataHandler handler, String subId, String consumerGroup) throws SubscribeException;

    void subscribe(INewDataHandler handler, String subId, String consumerGroup,
                   ConnectionStateListener connectionStateListener) throws SubscribeException;

    /**
     * cancel subscription
     *
     * @throws SubscribeException
     */
    void unsubscribe() throws SubscribeException;
}
