/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.builder.impl.BuildContext;
import com.envoisolutions.sxc.builder.impl.CodeWriterImpl;
import com.envoisolutions.sxc.compiler.Compiler;
import com.envoisolutions.sxc.jaxb.JAXBClass;
import com.envoisolutions.sxc.jaxb.JAXBEnumBuilder;
import com.envoisolutions.sxc.jaxb.JAXBIntrospectorImpl;
import com.envoisolutions.sxc.jaxb.JAXBObjectBuilder;
import com.envoisolutions.sxc.jaxb.JAXBObjectFactoryBuilder;
import com.envoisolutions.sxc.jaxb.JavaUtils;
import com.envoisolutions.sxc.jaxb.ObjectFactoryIntrospector;
import com.envoisolutions.sxc.jaxb.ReaderIntrospector;
import com.envoisolutions.sxc.jaxb.RuntimeContext;
import com.envoisolutions.sxc.jaxb.WriterIntrospector;
import com.envoisolutions.sxc.jaxb.model.Model;
import com.envoisolutions.sxc.jaxb.model.RiModelBuilder;
import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderContext {
    private BuildContext buildContext;
    private JCodeModel codeModel;
    private final Map<Class, JAXBObjectBuilder> jaxbObjectBuilders = new HashMap<Class, JAXBObjectBuilder>();
    private final Map<Class, JAXBEnumBuilder> jaxbEnumBuilders = new HashMap<Class, JAXBEnumBuilder>();
    private final Map<Class, JAXBObjectFactoryBuilder> jaxbObjectFactoryBuilders = new HashMap<Class, JAXBObjectFactoryBuilder>();
    private final Map<Class, JAXBClass> jaxbClasses = new HashMap<Class, JAXBClass>();
    private final Map<String, ?> properties;
    private Callable<JAXBContext> schemaGenerator;
    private Map<String, File> sources;

    public BuilderContext(Map<String, ?> properties, Class ... classes) throws JAXBException {
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        this.properties = properties;
        this.buildContext = new BuildContext();
        this.codeModel = this.buildContext.getCodeModel();
        this.buildContext.setUnmarshalContextClass(this.codeModel.ref(RuntimeContext.class));
        this.buildContext.setMarshalContextClass(this.codeModel.ref(RuntimeContext.class));
        RiModelBuilder modelBuilder = new RiModelBuilder(properties, classes);
        Model model = modelBuilder.getModel();
        this.schemaGenerator = modelBuilder.getContext();
        new ReaderIntrospector(this, model);
        new WriterIntrospector(this, model);
        new ObjectFactoryIntrospector(this, model);
    }

    public BuildContext getBuildContext() {
        return this.buildContext;
    }

    public JCodeModel getCodeModel() {
        return this.buildContext.getCodeModel();
    }

    public Callable<JAXBContext> getSchemaGenerator() {
        return this.schemaGenerator;
    }

    public JAXBObjectBuilder getJAXBObjectBuilder(Class type) {
        JAXBObjectBuilder builder = this.jaxbObjectBuilders.get(type);
        return builder;
    }

    public JAXBObjectBuilder createJAXBObjectBuilder(Class type, QName xmlRootElement, QName xmlType, boolean mixed) {
        JAXBObjectBuilder builder = this.jaxbObjectBuilders.get(type);
        if (builder == null) {
            builder = new JAXBObjectBuilder(this, type, xmlRootElement, xmlType, mixed);
            this.jaxbObjectBuilders.put(type, builder);
        }
        return builder;
    }

    public JAXBEnumBuilder getJAXBEnumBuilder(Class type) {
        JAXBEnumBuilder builder = this.jaxbEnumBuilders.get(type);
        return builder;
    }

    public JAXBEnumBuilder createJAXBEnumBuilder(Class type, QName xmlRootElement, QName xmlType) {
        JAXBEnumBuilder builder = this.jaxbEnumBuilders.get(type);
        if (builder == null) {
            builder = new JAXBEnumBuilder(this, type, xmlRootElement, xmlType);
            this.jaxbEnumBuilders.put(type, builder);
        }
        return builder;
    }

    public JAXBObjectFactoryBuilder getJAXBObjectFactoryBuilder(Class type) {
        JAXBObjectFactoryBuilder builder = this.jaxbObjectFactoryBuilders.get(type);
        return builder;
    }

    public JAXBObjectFactoryBuilder createJAXBObjectFactoryBuilder(Class type) {
        JAXBObjectFactoryBuilder builder = this.jaxbObjectFactoryBuilders.get(type);
        if (builder == null) {
            builder = new JAXBObjectFactoryBuilder(this, type);
            this.jaxbObjectFactoryBuilders.put(type, builder);
        }
        return builder;
    }

    public void write(CodeWriter codeWriter) throws IOException, BuildException {
        for (JAXBObjectBuilder builder : this.jaxbObjectBuilders.values()) {
            builder.write();
        }
        this.buildContext.getCodeModel().build(codeWriter);
    }

    public Collection<JAXBClass> compile() {
        if (!(this.jaxbObjectBuilders.isEmpty() && this.jaxbEnumBuilders.isEmpty() && this.jaxbObjectFactoryBuilders.isEmpty())) {
            JAXBClass jaxbClass;
            Compiler compiler = Compiler.newInstance((String)((String)this.properties.get("org.sxc.compiler")));
            ClassLoader classLoader = compiler.compile(this.getSources());
            for (Class type : this.jaxbObjectBuilders.keySet()) {
                jaxbClass = JAXBIntrospectorImpl.loadJAXBClass(type, classLoader);
                if (jaxbClass == null) continue;
                this.jaxbClasses.put(type, jaxbClass);
            }
            for (Class type : this.jaxbEnumBuilders.keySet()) {
                jaxbClass = JAXBIntrospectorImpl.loadJAXBClass(type, classLoader);
                if (jaxbClass == null) continue;
                this.jaxbClasses.put(type, jaxbClass);
            }
            for (Class type : this.jaxbObjectFactoryBuilders.keySet()) {
                jaxbClass = JAXBIntrospectorImpl.loadJAXBClass(type, classLoader);
                if (jaxbClass == null) continue;
                this.jaxbClasses.put(type, jaxbClass);
            }
            this.buildContext = null;
            this.codeModel = null;
            this.jaxbObjectBuilders.clear();
            this.jaxbEnumBuilders.clear();
            this.jaxbObjectFactoryBuilders.clear();
        }
        return this.jaxbClasses.values();
    }

    public Map<String, File> getSources() {
        if (this.sources == null) {
            CodeWriterImpl codeWriter;
            try {
                codeWriter = new CodeWriterImpl((String)this.properties.get("com.envoisolutions.sxc.output.directory"));
                this.write((CodeWriter)codeWriter);
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
            this.sources = codeWriter.getSources();
        }
        return this.sources;
    }

    public JClass toJClass(Class clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Internal Error: clazz is a primitive");
        }
        return this.codeModel.ref(clazz);
    }

    public JType toJType(Class<?> c) {
        return this.codeModel._ref(c);
    }

    public JClass getGenericType(Type type) {
        if (type instanceof Class) {
            Class clazz = this.toPrimitiveWrapper((Class)type);
            return this.codeModel.ref(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            JClass raw = (JClass)this.toJType(JavaUtils.toClass(pt.getRawType()));
            Type[] actualTypes = pt.getActualTypeArguments();
            ArrayList<JClass> types = new ArrayList<JClass>(actualTypes.length);
            for (Type actual : actualTypes) {
                if (actual instanceof WildcardType) {
                    WildcardType actualWildcard = (WildcardType)actual;
                    Type[] upperBounds = actualWildcard.getUpperBounds();
                    if (upperBounds.length > 0) {
                        types.add(this.getGenericType(upperBounds[0]).wildcard());
                        continue;
                    }
                    types.add(this.toJClass(Object.class));
                    continue;
                }
                types.add(this.getGenericType(actual));
            }
            raw = raw.narrow(types);
            return raw;
        }
        throw new IllegalStateException();
    }

    private Class toPrimitiveWrapper(Class type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        return type;
    }

    public JExpression dotclass(Type type) {
        Class clazz = JavaUtils.toClass(type);
        if (clazz.isPrimitive()) {
            return this.toJType(clazz).boxify().staticRef("TYPE");
        }
        return this.toJClass(clazz).dotclass();
    }
}

