/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.jaxb.BuilderContext;
import com.envoisolutions.sxc.jaxb.JAXBClass;
import com.envoisolutions.sxc.jaxb.JAXBIntrospectorImpl;
import com.envoisolutions.sxc.jaxb.MarshallerImpl;
import com.envoisolutions.sxc.jaxb.UnmarshallerImpl;
import com.sun.xml.bind.v2.ContextFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextImpl
extends JAXBContext {
    private static final Logger logger = Logger.getLogger(JAXBContextImpl.class.getName());
    private final JAXBIntrospectorImpl introspector = new JAXBIntrospectorImpl();
    private final Callable<JAXBContext> schemaGenerator;

    public static synchronized JAXBContextImpl newInstance(Class ... classes) throws JAXBException {
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(classes, Collections.emptyMap());
        return jaxbContext;
    }

    public static synchronized JAXBContextImpl newInstance(Class[] classes, Map<String, ?> properties) throws JAXBException {
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(classes, properties);
        return jaxbContext;
    }

    public static synchronized JAXBContextImpl createContext(Class[] classes, Map<String, ?> properties) throws JAXBException {
        JAXBContextImpl jaxbContext = new JAXBContextImpl(properties, classes);
        return jaxbContext;
    }

    public static JAXBContext newInstance(String contextPath) throws JAXBException {
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(contextPath, Thread.currentThread().getContextClassLoader(), Collections.emptyMap());
        return jaxbContext;
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader) throws JAXBException {
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(contextPath, classLoader, Collections.emptyMap());
        return jaxbContext;
    }

    public static synchronized JAXBContextImpl newInstance(String contextPath, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(contextPath, classLoader, properties);
        return jaxbContext;
    }

    public static synchronized JAXBContextImpl createContext(String contextPath, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        Class[] classes = JAXBContextImpl.loadPackageClasses(contextPath, classLoader);
        JAXBContextImpl jaxbContext = JAXBContextImpl.createContext(classes, properties);
        return jaxbContext;
    }

    public JAXBContextImpl(Class ... classes) throws JAXBException {
        this((Map<String, ?>)null, classes);
    }

    public JAXBContextImpl(final Map<String, ?> properties, final Class ... classes) throws JAXBException {
        String generateProperty = properties != null ? (String)properties.get("com.envoisolutions.sxc.generate") : null;
        boolean generate = true;
        if (generateProperty != null) {
            generate = Boolean.parseBoolean(generateProperty);
        }
        LinkedList<Class> unknownTypes = new LinkedList<Class>();
        for (Class xmlType : classes) {
            JAXBClass jaxbClass = JAXBIntrospectorImpl.loadJAXBClass(xmlType, null);
            if (jaxbClass != null) {
                this.introspector.addJAXBClass(jaxbClass);
                continue;
            }
            unknownTypes.add(xmlType);
        }
        if (unknownTypes.isEmpty()) {
            this.schemaGenerator = new Callable<JAXBContext>(){

                @Override
                public JAXBContext call() throws Exception {
                    JAXBContext context = ContextFactory.createContext((Class[])classes, (Map)properties);
                    return context;
                }
            };
        } else if (generate) {
            BuilderContext builder = new BuilderContext(properties, classes);
            this.schemaGenerator = builder.getSchemaGenerator();
            for (JAXBClass jaxbClass : builder.compile()) {
                this.introspector.addJAXBClass(jaxbClass);
            }
        } else {
            throw new JAXBException("Generation is disabled but no JaxB parser is available for the classes " + unknownTypes);
        }
        logger.info("Created SXC JAXB Context.");
    }

    public Marshaller createMarshaller() throws JAXBException {
        return new MarshallerImpl(this.introspector);
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        return new UnmarshallerImpl(this.introspector);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        return this.introspector;
    }

    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = this.schemaGenerator.call();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jaxbContext == null) {
            throw new UnsupportedOperationException("Schema generation is not supported");
        }
        jaxbContext.generateSchema(outputResolver);
    }

    public Validator createValidator() throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public static Class[] loadPackageClasses(String contextPath, ClassLoader classLoader) throws JAXBException {
        HashSet<Class> classes = new HashSet<Class>();
        for (String pkg : contextPath.split(":")) {
            List<Class> indexedClasses;
            Class objectFactoryClass = JAXBContextImpl.loadObjectFactory(pkg, classLoader);
            if (objectFactoryClass != null) {
                classes.add(objectFactoryClass);
            }
            if ((indexedClasses = JAXBContextImpl.loadIndexedClasses(pkg, classLoader)) != null) {
                classes.addAll(indexedClasses);
            }
            if (objectFactoryClass != null || indexedClasses != null) continue;
            throw new JAXBException("Package must contain a jaxb.index file or ObjectFactory class: " + pkg);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class> loadIndexedClasses(String pkg, ClassLoader classLoader) throws JAXBException {
        ArrayList<Class> arrayList;
        String resource = pkg.replace('.', '/') + "/jaxb.index";
        InputStream resourceAsStream = classLoader.getResourceAsStream(resource);
        if (resourceAsStream == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(resourceAsStream, "UTF-8"));
        try {
            ArrayList<Class> classes = new ArrayList<Class>();
            String className = in.readLine();
            while (className != null) {
                if ((className = className.trim()).startsWith("#") || className.length() == 0) {
                    className = in.readLine();
                    continue;
                }
                if (className.endsWith(".class")) {
                    throw new JAXBException("Illegal entry: " + className);
                }
                try {
                    classes.add(classLoader.loadClass(pkg + '.' + className));
                }
                catch (ClassNotFoundException e) {
                    throw new JAXBException("Error loading class: " + className, (Throwable)e);
                }
                className = in.readLine();
            }
            arrayList = classes;
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JAXBException("Error loading jaxb.index file for " + pkg, (Throwable)e);
            }
        }
        in.close();
        return arrayList;
    }

    private static Class loadObjectFactory(String pkg, ClassLoader classLoader) throws JAXBException {
        try {
            Class<?> objectFactory = classLoader.loadClass(pkg + ".ObjectFactory");
            return objectFactory;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

