/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.jaxb.JAXBClass;
import com.envoisolutions.sxc.jaxb.JAXBObject;
import com.envoisolutions.sxc.jaxb.JAXBObjectFactory;
import com.envoisolutions.sxc.jaxb.StandardJAXBObjects;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBIntrospectorImpl
extends JAXBIntrospector {
    private final Map<Class, JAXBObject> jaxbObjectByClass = new LinkedHashMap<Class, JAXBObject>();
    private final Map<QName, JAXBObject> jaxbObjectByElementName = new LinkedHashMap<QName, JAXBObject>();
    private final Map<QName, JAXBObject> jaxbObjectBySchemaType = new LinkedHashMap<QName, JAXBObject>();
    private boolean fullyResolved = false;

    public JAXBIntrospectorImpl() {
    }

    public JAXBIntrospectorImpl(JAXBObject ... jaxbObjects) {
        for (JAXBObject jaxbObject : jaxbObjects) {
            this.addJAXBClass(jaxbObject);
        }
    }

    public void addJAXBClass(JAXBClass jaxbClass) {
        if (this.jaxbObjectByClass.containsKey(jaxbClass.getType())) {
            return;
        }
        if (jaxbClass instanceof JAXBObject) {
            JAXBObject jaxbObject = (JAXBObject)jaxbClass;
            this.jaxbObjectByClass.put(jaxbObject.getType(), jaxbObject);
            if (jaxbObject.getXmlRootElement() != null) {
                this.jaxbObjectByElementName.put(jaxbObject.getXmlRootElement(), jaxbObject);
            }
            if (jaxbObject.getXmlType() != null) {
                this.jaxbObjectBySchemaType.put(jaxbObject.getXmlType(), jaxbObject);
            }
        }
        if (jaxbClass instanceof JAXBObjectFactory) {
            JAXBObjectFactory jaxbObjectFactory = (JAXBObjectFactory)jaxbClass;
            Map<QName, Class<JAXBObject>> map = jaxbObjectFactory.getRootElements();
            for (Map.Entry<QName, Class<JAXBObject>> rootElements : map.entrySet()) {
                Class<JAXBObject> jaxbObjectClass = rootElements.getValue();
                JAXBObject jaxbObject = (JAXBObject)JAXBIntrospectorImpl.createJAXBClassInstance(jaxbObjectClass);
                this.jaxbObjectByElementName.put(rootElements.getKey(), jaxbObject);
            }
        }
        if (this.fullyResolved) {
            this.resolveDependencies(jaxbClass);
        }
    }

    public <T> JAXBObject<T> getJaxbMarshaller(Class<T> type) {
        if (type == null) {
            return null;
        }
        JAXBObject jaxbObject = this.jaxbObjectByClass.get(type);
        if (jaxbObject == null) {
            jaxbObject = StandardJAXBObjects.jaxbObjectByClass.get(type);
        }
        if (jaxbObject == null) {
            this.setFullyResolved(true);
            jaxbObject = this.jaxbObjectByClass.get(type);
        }
        return jaxbObject;
    }

    public JAXBObject getJaxbMarshallerByElementName(QName elementName) {
        if (elementName == null) {
            return null;
        }
        JAXBObject jaxbObject = this.jaxbObjectByElementName.get(elementName);
        if (jaxbObject == null) {
            this.setFullyResolved(true);
            jaxbObject = this.jaxbObjectByElementName.get(elementName);
        }
        return jaxbObject;
    }

    public JAXBObject getJaxbMarshallerBySchemaType(QName schemaType) {
        if (schemaType == null) {
            return null;
        }
        JAXBObject jaxbObject = this.jaxbObjectBySchemaType.get(schemaType);
        if (jaxbObject == null) {
            jaxbObject = StandardJAXBObjects.jaxbObjectBySchemaType.get(schemaType);
        }
        if (jaxbObject == null) {
            this.setFullyResolved(true);
            jaxbObject = this.jaxbObjectBySchemaType.get(schemaType);
        }
        return jaxbObject;
    }

    public boolean isElement(Object jaxbElement) {
        return this.getElementName(jaxbElement) != null;
    }

    public QName getElementName(Object jaxbElement) {
        if (jaxbElement instanceof JAXBElement) {
            JAXBElement element = (JAXBElement)jaxbElement;
            return element.getName();
        }
        JAXBObject<?> jaxbObject = this.getJaxbMarshaller(jaxbElement.getClass());
        if (jaxbObject == null) {
            return null;
        }
        return jaxbObject.getXmlRootElement();
    }

    public Set<QName> getElementNames() {
        return this.jaxbObjectByElementName.keySet();
    }

    public boolean isFullyResolved() {
        return this.fullyResolved;
    }

    public void setFullyResolved(boolean fullyResolved) {
        if (this.fullyResolved == fullyResolved) {
            return;
        }
        this.fullyResolved = fullyResolved;
        if (fullyResolved) {
            for (JAXBObject jaxbObject : new ArrayList<JAXBObject>(this.jaxbObjectByClass.values())) {
                this.resolveDependencies(jaxbObject);
            }
        }
    }

    private void resolveDependencies(JAXBClass jaxbClass) {
        Collection<Class<JAXBClass>> dependencies = jaxbClass.getDependencies();
        for (Class<JAXBClass> marshallerClass : dependencies) {
            JAXBClass depencency = JAXBIntrospectorImpl.createJAXBClassInstance(marshallerClass);
            this.addJAXBClass(depencency);
        }
    }

    public static JAXBClass loadJAXBClass(Class type, ClassLoader classLoader) {
        Class<?> readerClass;
        if (classLoader == null) {
            classLoader = type.getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            readerClass = classLoader.loadClass("sxc." + type.getName() + "JAXB");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return JAXBIntrospectorImpl.createJAXBClassInstance(readerClass.asSubclass(JAXBClass.class));
    }

    public static JAXBClass createJAXBClassInstance(Class<? extends JAXBClass> readerClass) {
        JAXBClass jaxbClass = null;
        try {
            Field instanceField = readerClass.getField("INSTANCE");
            jaxbClass = (JAXBObject)instanceField.get(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jaxbClass == null) {
            try {
                jaxbClass = readerClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jaxbClass;
    }
}

