/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.jaxb.BuilderContext;
import com.envoisolutions.sxc.jaxb.JAXBEnumBuilder;
import com.envoisolutions.sxc.jaxb.JAXBObject;
import com.envoisolutions.sxc.jaxb.JAXBObjectBuilder;
import com.envoisolutions.sxc.jaxb.JAXBObjectFactory;
import com.envoisolutions.sxc.jaxb.StandardJAXBObjects;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;

public class JAXBObjectFactoryBuilder {
    private final BuilderContext builderContext;
    private final Class type;
    private final JDefinedClass jaxbObjectFactoryClass;
    private JMethod constructor;
    private JInvocation superInvocation;
    private Set<String> dependencies = new TreeSet<String>();
    private JFieldVar rootElements;

    public JAXBObjectFactoryBuilder(BuilderContext builderContext, Class type) {
        this.builderContext = builderContext;
        this.type = type;
        String className = "sxc." + type.getName() + "JAXB";
        try {
            this.jaxbObjectFactoryClass = builderContext.getCodeModel()._class(className);
            this.jaxbObjectFactoryClass._extends(builderContext.getCodeModel().ref(JAXBObjectFactory.class).narrow(type));
        }
        catch (JClassAlreadyExistsException e) {
            throw new BuildException((Throwable)e);
        }
        this.jaxbObjectFactoryClass.field(25, (JType)this.jaxbObjectFactoryClass, "INSTANCE", (JExpression)JExpr._new((JClass)this.jaxbObjectFactoryClass));
        this.constructor = this.jaxbObjectFactoryClass.constructor(1);
        this.superInvocation = this.constructor.body().invoke("super").arg(JExpr.dotclass((JClass)builderContext.toJClass(type)));
        JClass qnameJClass = builderContext.toJClass(QName.class);
        JClass extendsJAXBObjectClass = builderContext.toJClass(Class.class).narrow(builderContext.toJClass(JAXBObject.class).wildcard());
        JClass rootElementsType = builderContext.toJClass(Map.class).narrow(new JClass[]{qnameJClass, extendsJAXBObjectClass});
        this.rootElements = this.jaxbObjectFactoryClass.field(12, (JType)rootElementsType, "rootElements");
        this.rootElements.init((JExpression)JExpr._new((JClass)builderContext.toJClass(HashMap.class).narrow(new JClass[]{qnameJClass, extendsJAXBObjectClass})));
        JMethod method = this.jaxbObjectFactoryClass.method(1, (JType)rootElementsType, "getRootElements");
        method.body()._return((JExpression)this.rootElements);
    }

    private JExpression newQName(QName xmlRootElement) {
        if (xmlRootElement == null) {
            return JExpr._null();
        }
        return JExpr._new((JClass)this.builderContext.toJClass(QName.class)).arg((JExpression)JExpr.lit((String)xmlRootElement.getNamespaceURI()).invoke("intern")).arg((JExpression)JExpr.lit((String)xmlRootElement.getLocalPart()).invoke("intern"));
    }

    public Class getType() {
        return this.type;
    }

    public JDefinedClass getJAXBObjectFactoryClass() {
        return this.jaxbObjectFactoryClass;
    }

    public void addDependency(Class type) {
        if (!type.isEnum()) {
            JAXBObjectBuilder objectBuilder = this.builderContext.getJAXBObjectBuilder(type);
            if (objectBuilder != null) {
                this.addDependency((JClass)objectBuilder.getJAXBObjectClass());
            }
        } else {
            JAXBEnumBuilder enumBuilder = this.builderContext.getJAXBEnumBuilder(type);
            if (enumBuilder != null) {
                this.addDependency((JClass)enumBuilder.getJAXBEnumClass());
            }
        }
    }

    public void addDependency(JClass dependency) {
        if (this.jaxbObjectFactoryClass.fullName().equals(dependency.fullName())) {
            return;
        }
        if (this.dependencies.add(dependency.fullName())) {
            this.superInvocation.arg(dependency.dotclass());
        }
    }

    public void addRootElement(QName name, Class type) {
        if (!type.isEnum()) {
            JAXBObjectBuilder objectBuilder = this.builderContext.getJAXBObjectBuilder(type);
            if (objectBuilder != null) {
                this.constructor.body().invoke((JExpression)this.rootElements, "put").arg(this.newQName(name)).arg(objectBuilder.getJAXBObjectClass().dotclass());
            } else {
                JAXBObject jaxbObject = StandardJAXBObjects.jaxbObjectByClass.get(type);
                if (jaxbObject != null) {
                    this.constructor.body().invoke((JExpression)this.rootElements, "put").arg(this.newQName(name)).arg(this.builderContext.dotclass(jaxbObject.getClass()));
                }
            }
        } else {
            JAXBEnumBuilder enumBuilder = this.builderContext.getJAXBEnumBuilder(type);
            if (enumBuilder != null) {
                this.constructor.body().invoke((JExpression)this.rootElements, "put").arg(this.newQName(name)).arg(enumBuilder.getJAXBEnumClass().dotclass());
            }
        }
    }
}

