/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.jaxb.JavaUtils;
import java.lang.reflect.Method;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class LifecycleCallback {
    public final Method beforeUnmarshal;
    public final Method afterUnmarshal;
    public final Method beforeMarshal;
    public final Method afterMarshal;

    public LifecycleCallback(Method beforeUnmarshal, Method afterUnmarshal, Method beforeMarshal, Method afterMarshal) {
        this.beforeUnmarshal = beforeUnmarshal;
        this.afterUnmarshal = afterUnmarshal;
        this.beforeMarshal = beforeMarshal;
        this.afterMarshal = afterMarshal;
    }

    public LifecycleCallback(Class beanType) {
        if (beanType == null) {
            throw new NullPointerException("clazz is null");
        }
        this.beforeUnmarshal = LifecycleCallback.getDeclaredMethod(beanType, "beforeUnmarshal", Unmarshaller.class, Object.class);
        this.afterUnmarshal = LifecycleCallback.getDeclaredMethod(beanType, "afterUnmarshal", Unmarshaller.class, Object.class);
        this.beforeMarshal = LifecycleCallback.getDeclaredMethod(beanType, "beforeMarshal", Marshaller.class);
        this.afterMarshal = LifecycleCallback.getDeclaredMethod(beanType, "afterMarshal", Marshaller.class);
    }

    private static Method getDeclaredMethod(Class type, String name, Class ... parameterTypes) {
        Method method;
        try {
            method = type.getDeclaredMethod(name, parameterTypes);
        }
        catch (Exception ignored) {
            return null;
        }
        if (JavaUtils.isPrivate(method)) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access non-public methods");
            }
        }
        return method;
    }

    public void beforeUnmarshal(Object bean, Unmarshaller unmarshaller, Object parent) throws Exception {
        if (this.beforeUnmarshal != null) {
            this.beforeUnmarshal.invoke(bean, unmarshaller, parent);
        }
    }

    public void afterUnmarshal(Object bean, Unmarshaller unmarshaller, Object parent) throws Exception {
        if (this.afterUnmarshal != null) {
            this.afterUnmarshal.invoke(bean, unmarshaller, parent);
        }
    }

    public void beforeMarshal(Object bean, Marshaller marshaller) throws Exception {
        if (this.beforeMarshal != null) {
            this.beforeMarshal.invoke(bean, marshaller);
        }
    }

    public void afterMarshal(Object bean, Marshaller marshaller) throws Exception {
        if (this.afterMarshal != null) {
            this.afterMarshal.invoke(bean, marshaller);
        }
    }
}

