/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.jaxb.BinaryUtils;
import com.envoisolutions.sxc.jaxb.JAXBIntrospectorImpl;
import com.envoisolutions.sxc.jaxb.JAXBObject;
import com.envoisolutions.sxc.jaxb.RuntimeContext;
import com.envoisolutions.sxc.jaxb.StandardJAXBObjects;
import com.envoisolutions.sxc.jaxb.ValidationEventLocatorImpl;
import com.envoisolutions.sxc.util.PrettyPrintXMLStreamWriter;
import com.envoisolutions.sxc.util.RuntimeXMLStreamException;
import com.envoisolutions.sxc.util.W3CDOMStreamWriter;
import com.envoisolutions.sxc.util.XoXMLStreamWriter;
import com.envoisolutions.sxc.util.XoXMLStreamWriterImpl;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.helpers.AbstractMarshallerImpl;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.validation.Schema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarshallerImpl
extends AbstractMarshallerImpl {
    public static final String MARSHALLER = "sxc.marshaller";
    private final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private final JAXBIntrospectorImpl introspector;
    private final Map<Class<?>, ? super XmlAdapter> adapters = new HashMap();
    private AttachmentMarshaller attachmentMarshaller;
    private Marshaller.Listener listener;
    private Schema schema;

    public MarshallerImpl(JAXBIntrospectorImpl introspector) {
        this.introspector = introspector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void marshal(Object jaxbElement, Result result) throws JAXBException {
        if (jaxbElement == null) {
            throw new IllegalArgumentException("jaxbElement is null");
        }
        if (result == null) {
            throw new IllegalArgumentException("result is null");
        }
        XMLStreamWriter writer = null;
        try {
            if (result instanceof DOMResult) {
                Node node = ((DOMResult)result).getNode();
                if (node instanceof Document) {
                    writer = new W3CDOMStreamWriter((Document)node);
                } else {
                    if (!(node instanceof Element)) throw new UnsupportedOperationException("Node type not supported.");
                    writer = new W3CDOMStreamWriter((Element)node);
                }
            } else {
                writer = this.xmlOutputFactory.createXMLStreamWriter(result);
            }
            this.marshal(jaxbElement, writer);
            return;
        }
        catch (XMLStreamException e) {
            throw new JAXBException("Could not close XMLStreamWriter.", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException ignored) {}
            }
        }
    }

    public void marshal(Object jaxbElement, XMLEventWriter writer) throws JAXBException {
        throw new UnsupportedOperationException();
    }

    public void marshal(Object jaxbElement, XMLStreamWriter writer) throws JAXBException {
        if (jaxbElement == null) {
            throw new IllegalArgumentException("jaxbElement is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("xsw is null");
        }
        if (!this.introspector.isElement(jaxbElement)) {
            throw new MarshalException("Object must be annotated with @XmlRootElement or be a JAXBElement!");
        }
        if (this.isFormattedOutput()) {
            writer = new PrettyPrintXMLStreamWriter(writer);
        }
        XoXMLStreamWriterImpl w = new XoXMLStreamWriterImpl(writer);
        try {
            if (!this.isFragment()) {
                w.writeStartDocument(this.getEncoding(), null);
            }
            boolean writeXsiType = true;
            if (jaxbElement instanceof JAXBElement) {
                writeXsiType = ((JAXBElement)jaxbElement).isTypeSubstituted();
            } else {
                JAXBObject<?> jaxbObject = this.introspector.getJaxbMarshaller(jaxbElement.getClass());
                if (jaxbObject != null) {
                    writeXsiType = jaxbObject.getXmlRootElement() == null && jaxbObject.getXmlType() != null;
                }
            }
            this.write(jaxbElement, (XoXMLStreamWriter)w, new RuntimeContext(this), true, writeXsiType);
            if (!this.isFragment()) {
                w.writeEndDocument();
            }
        }
        catch (XMLStreamException e) {
            throw new MarshalException((Throwable)e);
        }
    }

    public void write(Object jaxbElement, XoXMLStreamWriter writer, RuntimeContext context, boolean writeTag, boolean writeXsiType) throws JAXBException {
        if (jaxbElement == null) {
            throw new IllegalArgumentException("jaxbElement is null");
        }
        if (writer == null) {
            throw new IllegalArgumentException("writer is null");
        }
        try {
            JAXBObject<?> jaxbObject;
            if (writeTag) {
                QName name;
                Object element;
                if (jaxbElement instanceof JAXBElement) {
                    element = (JAXBElement)jaxbElement;
                    writeXsiType = writeXsiType || element.isTypeSubstituted();
                    name = element.getName();
                    jaxbElement = element.getValue();
                } else if (jaxbElement instanceof Element) {
                    element = (Element)jaxbElement;
                    String namespaceURI = element.getNamespaceURI();
                    if (namespaceURI == null) {
                        namespaceURI = "";
                    }
                    name = new QName(namespaceURI, element.getLocalName());
                } else {
                    jaxbObject = this.introspector.getJaxbMarshaller(jaxbElement.getClass());
                    if (jaxbObject == null || jaxbObject.getXmlRootElement() == null) {
                        throw new MarshalException("Object must be annotated with @XmlRootElement or be a JAXBElement!");
                    }
                    name = jaxbObject.getXmlRootElement();
                }
                writer.writeStartElementWithAutoPrefix(name.getNamespaceURI(), name.getLocalPart());
            }
            if (jaxbElement instanceof JAXBElement && ((JAXBElement)jaxbElement).isNil()) {
                writer.writeXsiNil();
            } else if (jaxbElement != null) {
                Class<?> c = jaxbElement.getClass();
                if (c == String.class) {
                    writer.writeCharacters((String)jaxbElement);
                } else if (c == Boolean.class) {
                    writer.writeBoolean(((Boolean)jaxbElement).booleanValue());
                } else if (c == Byte.class) {
                    writer.writeByte(((Byte)jaxbElement).byteValue());
                } else if (c == Double.class) {
                    writer.writeDouble(((Double)jaxbElement).doubleValue());
                } else if (c == Float.class) {
                    writer.writeFloat(((Float)jaxbElement).floatValue());
                } else if (c == Long.class) {
                    writer.writeLong(((Long)jaxbElement).longValue());
                } else if (c == Integer.class) {
                    writer.writeInt(((Integer)jaxbElement).intValue());
                } else if (c == Short.class) {
                    writer.writeShort(((Short)jaxbElement).shortValue());
                } else if (Duration.class.isAssignableFrom(c)) {
                    writer.writeCharacters(jaxbElement.toString());
                } else if (XMLGregorianCalendar.class.isAssignableFrom(c)) {
                    writer.writeCharacters(((XMLGregorianCalendar)jaxbElement).toXMLFormat());
                } else if (Calendar.class.isAssignableFrom(c)) {
                    StandardJAXBObjects.CalendarJAXB.INSTANCE.write(writer, (Calendar)jaxbElement, context);
                } else if (c == byte[].class) {
                    BinaryUtils.encodeBytes((XMLStreamWriter)writer, (byte[])jaxbElement);
                } else if (Element.class.isAssignableFrom(c)) {
                    writer.writeDomElement((Element)jaxbElement, false);
                } else {
                    jaxbObject = this.introspector.getJaxbMarshaller(c);
                    if (jaxbObject != null) {
                        if (writeXsiType) {
                            writer.writeXsiType(jaxbObject.getXmlType().getNamespaceURI(), jaxbObject.getXmlType().getLocalPart());
                        }
                        jaxbObject.write(writer, jaxbElement, context);
                    } else {
                        String message = "No marshaller for " + c.getName();
                        if (this.getEventHandler() == null || !this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)new ValidationEventLocatorImpl(jaxbElement, null)))) {
                            throw new MarshalException(message);
                        }
                    }
                }
            }
            if (writeTag) {
                writer.writeEndElement();
            }
        }
        catch (Exception e2) {
            XMLStreamException e2;
            if (e2 instanceof JAXBException) {
                throw (JAXBException)((Object)e2);
            }
            if (e2 instanceof RuntimeXMLStreamException) {
                e2 = ((RuntimeXMLStreamException)e2).getCause();
            }
            if (this.getEventHandler() != null) {
                this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(2, "Fatal error", (ValidationEventLocator)new ValidationEventLocatorImpl(), (Throwable)e2));
            }
            if (e2 instanceof XMLStreamException) {
                Throwable cause = e2.getCause();
                if (cause instanceof JAXBException) {
                    throw (JAXBException)((Object)e2);
                }
                throw new MarshalException(cause == null ? e2 : cause);
            }
            throw new MarshalException((Throwable)e2);
        }
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.adapters.get(type);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        this.adapters.put(type, adapter);
    }

    public AttachmentMarshaller getAttachmentMarshaller() {
        return this.attachmentMarshaller;
    }

    public void setAttachmentMarshaller(AttachmentMarshaller attachmentMarshaller) {
        this.attachmentMarshaller = attachmentMarshaller;
    }

    public Marshaller.Listener getListener() {
        return this.listener;
    }

    public void setListener(Marshaller.Listener listener) {
        this.listener = listener;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }
}

