/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.builder.impl.JBlankLine;
import com.envoisolutions.sxc.builder.impl.JIfElseBlock;
import com.envoisolutions.sxc.builder.impl.JLineComment;
import com.envoisolutions.sxc.builder.impl.JStaticImports;
import com.envoisolutions.sxc.jaxb.BinaryUtils;
import com.envoisolutions.sxc.jaxb.BuilderContext;
import com.envoisolutions.sxc.jaxb.CollectionRefTarget;
import com.envoisolutions.sxc.jaxb.FieldRefTarget;
import com.envoisolutions.sxc.jaxb.JAXBEnumBuilder;
import com.envoisolutions.sxc.jaxb.JAXBObjectBuilder;
import com.envoisolutions.sxc.jaxb.JavaUtils;
import com.envoisolutions.sxc.jaxb.model.Bean;
import com.envoisolutions.sxc.jaxb.model.ElementMapping;
import com.envoisolutions.sxc.jaxb.model.EnumInfo;
import com.envoisolutions.sxc.jaxb.model.Model;
import com.envoisolutions.sxc.jaxb.model.Property;
import com.envoisolutions.sxc.util.ArrayUtil;
import com.envoisolutions.sxc.util.Base64;
import com.sun.codemodel.JArray;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.awt.Image;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReaderIntrospector {
    private static final Logger logger = Logger.getLogger(ReaderIntrospector.class.getName());
    private final BuilderContext context;
    private final Model model;
    private final Map<Bean, JAXBObjectBuilder> builders = new LinkedHashMap<Bean, JAXBObjectBuilder>();
    private final Map<Class, JAXBEnumBuilder> enumBuilders = new LinkedHashMap<Class, JAXBEnumBuilder>();

    public ReaderIntrospector(BuilderContext context, Model model) {
        this.context = context;
        this.model = model;
        for (EnumInfo enumInfo : model.getEnums()) {
            this.addEnum(enumInfo);
        }
        for (Bean bean : this.model.getBeans()) {
            boolean mixed = false;
            for (Property property : bean.getProperties()) {
                if (!property.isMixed() || property.getXmlName() != null) continue;
                mixed = true;
                break;
            }
            JAXBObjectBuilder builder = context.createJAXBObjectBuilder(bean.getType(), bean.getRootElementName(), bean.getSchemaTypeName(), mixed);
            LinkedHashSet<Property> allProperties = new LinkedHashSet<Property>();
            for (Bean b = bean; b != null; b = b.getBaseClass()) {
                allProperties.addAll(b.getProperties());
            }
            for (Property property : allProperties) {
                Field field = property.getField();
                if (field != null) {
                    if (!JavaUtils.isPrivate(field)) continue;
                    builder.getPrivateFieldAccessor(property.getField());
                    continue;
                }
                if (!JavaUtils.isPrivate(property.getGetter()) && !JavaUtils.isPrivate(property.getSetter())) continue;
                builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
            }
            for (Property property : allProperties) {
                if (property.getAdapterType() == null) continue;
                builder.getAdapter(property.getAdapterType());
            }
            this.builders.put(bean, builder);
        }
        for (Bean bean : model.getBeans()) {
            JAXBObjectBuilder builder;
            if (bean.getType().isEnum() || (builder = this.builders.get(bean)) == null) continue;
            this.add(builder, bean);
        }
    }

    private JInvocation invokeParser(JAXBObjectBuilder caller, JVar callerXsrVar, JAXBObjectBuilder parser) {
        caller.addDependency((JClass)parser.getJAXBObjectClass());
        String methodName = "read" + parser.getReadMethod().type().name();
        if (caller != parser) {
            JStaticImports staticImports = JStaticImports.getStaticImports((JDefinedClass)caller.getJAXBObjectClass());
            staticImports.addStaticImport(parser.getJAXBObjectClass().fullName() + "." + methodName);
        }
        JInvocation invocation = JExpr.invoke((String)methodName).arg((JExpression)callerXsrVar).arg((JExpression)caller.getReadContextVar());
        return invocation;
    }

    private JInvocation invokeEnumParser(JAXBObjectBuilder caller, JVar callerXsrVar, JAXBEnumBuilder parser, JExpression value) {
        caller.addDependency((JClass)parser.getJAXBEnumClass());
        String methodName = "parse" + parser.getType().getSimpleName();
        JStaticImports staticImports = JStaticImports.getStaticImports((JDefinedClass)caller.getJAXBObjectClass());
        staticImports.addStaticImport(parser.getJAXBEnumClass().fullName() + "." + methodName);
        JInvocation invocation = JExpr.invoke((String)methodName).arg((JExpression)callerXsrVar).arg((JExpression)caller.getReadContextVar()).arg(value);
        return invocation;
    }

    private JAXBObjectBuilder add(JAXBObjectBuilder builder, Bean bean) {
        if (!Modifier.isAbstract(bean.getType().getModifiers())) {
            this.handleProperties(builder, bean, builder.getReadObject());
        }
        for (Bean xsiTypeBean : this.model.getBeans()) {
            Class<?> xsiTypeClass = xsiTypeBean.getType();
            QName schemaTypeName = xsiTypeBean.getSchemaTypeName();
            if (!bean.getType().isAssignableFrom(xsiTypeClass) || schemaTypeName == null || bean.getType() == xsiTypeClass || Modifier.isAbstract(xsiTypeClass.getModifiers())) continue;
            JBlock block = builder.expectXsiType(schemaTypeName);
            JAXBObjectBuilder elementBuilder = this.builders.get(xsiTypeBean);
            if (elementBuilder == null) {
                throw new BuildException("Unknown bean " + bean);
            }
            JInvocation method = this.invokeParser(builder, builder.getXSR(), elementBuilder);
            block._return((JExpression)method);
        }
        return builder;
    }

    private void addEnum(EnumInfo enumInfo) {
        JAXBEnumBuilder builder = this.context.createJAXBEnumBuilder(enumInfo.getType(), enumInfo.getRootElementName(), enumInfo.getSchemaTypeName());
        JMethod method = builder.getParseMethod();
        JIfElseBlock enumCond = new JIfElseBlock();
        method.body().add((JStatement)enumCond);
        for (Map.Entry<Enum, String> entry : enumInfo.getEnumMap().entrySet()) {
            Enum enumValue = entry.getKey();
            String enumText = entry.getValue();
            JInvocation textCompare = JExpr.lit((String)enumText).invoke("equals").arg((JExpression)builder.getParseValue());
            JBlock block = enumCond.addCondition((JExpression)textCompare);
            block._return((JExpression)this.context.toJClass(enumInfo.getType()).staticRef(enumValue.name()));
        }
        JInvocation unexpectedInvoke = enumCond._else().invoke((JExpression)builder.getParseContext(), "unexpectedEnumValue").arg((JExpression)builder.getParseXSR()).arg(this.context.toJClass(enumInfo.getType()).dotclass()).arg((JExpression)builder.getParseValue());
        for (String expectedValue : enumInfo.getEnumMap().values()) {
            unexpectedInvoke.arg(expectedValue);
        }
        enumCond._else()._return(JExpr._null());
        this.enumBuilders.put(enumInfo.getType(), builder);
    }

    private void handleProperties(JAXBObjectBuilder builder, Bean bean, JVar beanVar) {
        block5: for (Property property : bean.getProperties()) {
            if (Character.TYPE.equals(property.getType()) || char[].class.equals((Object)property.getType())) {
                logger.info("(JAXB Reader) JaxB specification does not support property " + property.getName() + " with type " + property.getType() + " on " + bean.getClass() + ": Use a XmlAdapter");
                continue;
            }
            switch (property.getXmlStyle()) {
                case ATTRIBUTE: {
                    JBlock block;
                    if (!property.isXmlAny()) {
                        JInvocation value;
                        block = builder.expectAttribute(property.getXmlName());
                        block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
                        JVar collectionVar = this.handleCollection(builder, property, beanVar);
                        if (!property.isCollection()) {
                            value = builder.getAttributeVar().invoke("getValue");
                        } else {
                            JForEach forEach = block.forEach((JType)this.context.toJClass(String.class), builder.getReadVariableManager().createId(property.getName() + "Item"), (JExpression)builder.getAttributeVar().invoke("getXmlListValue"));
                            block = forEach.body();
                            value = forEach.var();
                        }
                        JExpression toSet = this.handleAttribute(builder, block, property, (JExpression)value);
                        this.doSet(builder, block, property, beanVar, toSet, collectionVar);
                        break;
                    }
                    this.handleAnyAttribute(builder, property, beanVar);
                    break;
                }
                case ELEMENT: 
                case ELEMENT_REF: {
                    JInvocation toSet;
                    JBlock block;
                    JAXBObjectBuilder elementBuilder = builder;
                    JVar parentVar = beanVar;
                    if (property.getXmlName() != null && !property.isXmlList()) {
                        elementBuilder = builder.expectWrapperElement(property.getXmlName(), beanVar, property.getName(), property.isMixed());
                    }
                    JVar collectionVar = this.handleCollection(elementBuilder, property, parentVar);
                    for (ElementMapping mapping : property.getElementMappings()) {
                        JExpression toSet2;
                        JBlock block2 = elementBuilder.expectElement(mapping.getXmlName());
                        block2.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
                        JVar xsrVar = builder.getChildElementVar();
                        if (!property.isXmlList()) {
                            JExpression toSet3 = this.handleElement(builder, xsrVar, block2, property, mapping.isNillable(), mapping.getComponentType());
                            this.doSet(builder, block2, property, parentVar, toSet3, collectionVar);
                            continue;
                        }
                        JForEach forEach = block2.forEach((JType)this.context.toJClass(String.class), builder.getReadVariableManager().createId(property.getName() + "Item"), (JExpression)xsrVar.invoke("getElementAsXmlList"));
                        block2 = forEach.body();
                        JVar value = forEach.var();
                        String propertyName = property.getName();
                        if (property.isCollection()) {
                            propertyName = propertyName + "Item";
                        }
                        propertyName = builder.getReadVariableManager().createId(propertyName);
                        if (property.isIdref() || property.getAdapterType() == null) {
                            toSet2 = this.coerce(builder, xsrVar, (JExpression)value, JavaUtils.toClass(mapping.getComponentType()));
                        } else {
                            JVar adapterVar = builder.getAdapter(property.getAdapterType());
                            block2.add((JStatement)new JBlankLine());
                            Class targetType = JavaUtils.toClass(mapping.getComponentType());
                            JVar valueVar = block2.decl((JType)this.context.toJClass(targetType), propertyName);
                            JTryBlock tryBlock = block2._try();
                            tryBlock.body().assign((JAssignmentTarget)valueVar, (JExpression)adapterVar.invoke("unmarshal").arg((JExpression)value));
                            JCatchBlock catchException = tryBlock._catch(this.context.toJClass(Exception.class));
                            JBlock catchBody = catchException.body();
                            catchBody.invoke((JExpression)builder.getReadContextVar(), "xmlAdapterError").arg((JExpression)xsrVar).arg(this.context.dotclass(property.getAdapterType())).arg(this.context.dotclass(targetType)).arg(this.context.dotclass(targetType)).arg((JExpression)catchException.param("e"));
                            catchBody._continue();
                            block2.add((JStatement)new JBlankLine());
                            toSet2 = valueVar;
                        }
                        if (JavaUtils.toClass(property.getComponentType()).equals(JAXBElement.class)) {
                            toSet2 = this.newJaxBElement(xsrVar, JavaUtils.toClass(mapping.getComponentType()), toSet2);
                        }
                        this.doSet(builder, block2, property, parentVar, toSet2, collectionVar);
                    }
                    if (property.isXmlAny()) {
                        block = elementBuilder.expectAnyElement();
                        block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
                        toSet = builder.getReadContextVar().invoke("readXmlAny").arg((JExpression)builder.getChildElementVar()).arg(this.context.dotclass(property.getComponentType())).arg(property.isLax() ? JExpr.TRUE : JExpr.FALSE);
                        this.doSet(builder, block, property, parentVar, (JExpression)toSet, collectionVar);
                    }
                    if (!property.isMixed()) continue block5;
                    block = elementBuilder.expectMixedElement();
                    block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + " (Mixed): " + property.getName()));
                    toSet = builder.getChildElementVar().invoke("getText");
                    this.doSet(builder, block, property, parentVar, (JExpression)toSet, collectionVar);
                    break;
                }
                case VALUE: {
                    JBlock block = builder.expectValue();
                    block.add((JStatement)new JBlankLine());
                    block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
                    this.handleValue(builder, builder.getXSR(), block, property, beanVar);
                }
            }
        }
        if (bean.getBaseClass() != null) {
            this.handleProperties(builder, bean.getBaseClass(), beanVar);
        }
    }

    private JExpression handleAttribute(JAXBObjectBuilder builder, JBlock block, Property property, JExpression value) {
        JExpression toSet;
        if (property.isIdref()) {
            toSet = value;
        } else if (property.getAdapterType() != null) {
            JVar adapterVar = builder.getAdapter(property.getAdapterType());
            toSet = adapterVar.invoke("unmarshal").arg(value);
        } else {
            String propertyName = property.getName();
            if (property.isCollection() || property.isXmlAny()) {
                propertyName = propertyName + "Item";
            }
            propertyName = builder.getReadVariableManager().createId(propertyName);
            Class clazz = JavaUtils.toClass(property.getComponentType());
            if (this.isBuiltinType(clazz)) {
                toSet = block.decl(this.context.toJType(clazz), propertyName, this.coerce(builder, builder.getXSR(), value, clazz));
            } else if (clazz.equals(byte[].class)) {
                toSet = this.context.toJClass(Base64.class).staticInvoke("decode").arg(value);
            } else if (clazz.equals(QName.class)) {
                JVar var = this.as(builder, value, block, String.class, propertyName);
                toSet = builder.getXSR().invoke("getAsQName").arg((JExpression)var);
            } else if (clazz.equals(DataHandler.class) || clazz.equals(Image.class)) {
                toSet = JExpr._null();
            } else {
                logger.severe("Could not map attribute " + propertyName + " of type " + clazz);
                toSet = JExpr._null();
            }
        }
        return toSet;
    }

    private void handleAnyAttribute(JAXBObjectBuilder builder, Property property, JVar beanVar) {
        JBlock assignMapBlock;
        Field field;
        JBlock block = builder.expectAnyAttribute();
        block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
        String mapVarName = builder.getReadVariableManager().createId(property.getName());
        JVar mapVar = builder.getReadMethod().body().decl((JType)this.context.getGenericType(property.getType()), mapVarName, JExpr._null());
        JExpression toSet = this.handleAttribute(builder, block, property, (JExpression)builder.getAttributeVar().invoke("getValue"));
        JBlock createMapBlock = block._if(mapVar.eq(JExpr._null()))._then();
        if (property.getField() == null && property.getGetter() == null) {
            JType mapType = this.getMapClass(property.getType(), property.getComponentType());
            if (mapType == null) {
                throw new BuildException("AnyAttribute map property does not have a getter and map does not have a default constructor: " + property.getBean().getType().getName() + "." + property.getName());
            }
            createMapBlock.assign((JAssignmentTarget)mapVar, (JExpression)JExpr._new((JType)mapType));
        } else {
            if (property.getField() != null) {
                field = property.getField();
                if (!JavaUtils.isPrivate(field)) {
                    createMapBlock.assign((JAssignmentTarget)mapVar, (JExpression)beanVar.ref(field.getName()));
                } else {
                    JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                    createMapBlock.assign((JAssignmentTarget)mapVar, (JExpression)fieldAccessorField.invoke("getObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar));
                }
            } else {
                Method getter = property.getGetter();
                if (!JavaUtils.isPrivate(getter)) {
                    JTryBlock tryGetter = createMapBlock._try();
                    tryGetter.body().assign((JAssignmentTarget)mapVar, (JExpression)beanVar.invoke(getter.getName()));
                    JCatchBlock catchException = tryGetter._catch(this.context.toJClass(Exception.class));
                    catchException.body().invoke((JExpression)builder.getReadContextVar(), "getterError").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(getter.getName()).arg((JExpression)catchException.param("e"));
                    catchException.body()._continue();
                } else {
                    JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                    createMapBlock.assign((JAssignmentTarget)mapVar, (JExpression)propertyAccessorField.invoke("getObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar));
                }
            }
            JConditional arrayFoundCondition = createMapBlock._if(mapVar.ne(JExpr._null()));
            arrayFoundCondition._then().invoke((JExpression)mapVar, "clear");
            JType mapType = this.getMapClass(property.getType(), property.getComponentType());
            if (mapType != null) {
                arrayFoundCondition._else().assign((JAssignmentTarget)mapVar, (JExpression)JExpr._new((JType)mapType));
            } else {
                arrayFoundCondition._else().invoke((JExpression)builder.getReadContextVar(), "uncreatableMap").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(property.getName()).arg(this.context.dotclass(property.getType()));
                arrayFoundCondition._else()._continue();
            }
        }
        block.add((JStatement)mapVar.invoke("put").arg((JExpression)builder.getAttributeVar().invoke("getName")).arg(toSet));
        if (property.getField() != null) {
            field = property.getField();
            assignMapBlock = builder.getReadTailBlock()._if(mapVar.ne(JExpr._null()))._then();
            if (!JavaUtils.isPrivate(field)) {
                assignMapBlock.assign((JAssignmentTarget)beanVar.ref(field.getName()), (JExpression)mapVar);
            } else {
                JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                assignMapBlock.add((JStatement)fieldAccessorField.invoke("setObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar).arg((JExpression)mapVar));
            }
        } else {
            Method setter = property.getSetter();
            if (setter != null) {
                assignMapBlock = builder.getReadTailBlock()._if(mapVar.ne(JExpr._null()))._then();
                if (!JavaUtils.isPrivate(setter)) {
                    JTryBlock trySetter = assignMapBlock._try();
                    trySetter.body().add((JStatement)beanVar.invoke(setter.getName()).arg((JExpression)mapVar));
                    JCatchBlock catchException = trySetter._catch(this.context.toJClass(Exception.class));
                    catchException.body().invoke((JExpression)builder.getReadContextVar(), "setterError").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(setter.getName()).arg(this.context.dotclass(setter.getParameterTypes()[0])).arg((JExpression)catchException.param("e"));
                } else {
                    JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                    assignMapBlock.add((JStatement)propertyAccessorField.invoke("setObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar).arg((JExpression)mapVar));
                }
            }
        }
    }

    private JExpression handleElement(JAXBObjectBuilder builder, JVar xsrVar, JBlock block, Property property, boolean nillable, Type componentType) {
        JInvocation toSet;
        String propertyName = property.getName();
        if (property.isCollection()) {
            propertyName = propertyName + "Item";
        }
        propertyName = builder.getReadVariableManager().createId(propertyName);
        if (property.isIdref()) {
            toSet = xsrVar.invoke("getElementAsString");
        } else if (property.getAdapterType() != null) {
            JVar adapterVar = builder.getAdapter(property.getAdapterType());
            JVar xmlValueVar = this.readElement(builder, xsrVar, block, nillable, builder.getReadVariableManager().createId(propertyName + "Raw"), property.getComponentAdaptedType());
            block.add((JStatement)new JBlankLine());
            Class targetType = JavaUtils.toClass(componentType);
            JVar valueVar = block.decl((JType)this.context.toJClass(targetType), propertyName);
            JTryBlock tryBlock = block._try();
            tryBlock.body().assign((JAssignmentTarget)valueVar, (JExpression)adapterVar.invoke("unmarshal").arg((JExpression)xmlValueVar));
            JCatchBlock catchException = tryBlock._catch(this.context.toJClass(Exception.class));
            JBlock catchBody = catchException.body();
            catchBody.invoke((JExpression)builder.getReadContextVar(), "xmlAdapterError").arg((JExpression)xsrVar).arg(this.context.dotclass(property.getAdapterType())).arg(this.context.dotclass(targetType)).arg(this.context.dotclass(targetType)).arg((JExpression)catchException.param("e"));
            catchBody._continue();
            block.add((JStatement)new JBlankLine());
            toSet = valueVar;
        } else {
            toSet = this.readElement(builder, xsrVar, block, nillable, propertyName, JavaUtils.toClass(componentType));
        }
        if (JavaUtils.toClass(property.getComponentType()).equals(JAXBElement.class)) {
            toSet = this.newJaxBElement(xsrVar, JavaUtils.toClass(componentType), (JExpression)toSet);
        }
        return toSet;
    }

    private JVar readElement(JAXBObjectBuilder builder, JVar xsrVar, JBlock block, boolean nillable, String propertyName, Class targetType) {
        JVar toSet;
        if (targetType.equals(Byte.class) || targetType.equals(Byte.TYPE)) {
            toSet = block.decl(this.context.toJType(Byte.TYPE), propertyName, (JExpression)JExpr.cast((JType)this.context.toJType(Byte.TYPE), (JExpression)xsrVar.invoke("getElementAsInt")));
        } else if (this.isBuiltinType(targetType)) {
            toSet = this.as(builder, xsrVar, block, targetType, propertyName, nillable);
        } else if (targetType.equals(byte[].class)) {
            toSet = block.decl((JType)this.context.toJClass(byte[].class), propertyName, (JExpression)this.context.toJClass(BinaryUtils.class).staticInvoke("decodeAsBytes").arg((JExpression)xsrVar));
        } else if (targetType.equals(QName.class)) {
            toSet = block.decl((JType)this.context.toJClass(QName.class), propertyName, (JExpression)xsrVar.invoke("getElementAsQName"));
        } else if (targetType.equals(DataHandler.class) || targetType.equals(Image.class)) {
            toSet = block.decl((JType)this.context.toJClass(targetType), propertyName, JExpr._null());
        } else if (targetType.equals(Object.class) || targetType.equals(Element.class)) {
            toSet = block.decl((JType)this.context.toJClass(Element.class), propertyName, (JExpression)xsrVar.invoke("getElementAsDomElement"));
        } else {
            Bean targetBean = this.model.getBean(targetType);
            JAXBObjectBuilder elementBuilder = this.builders.get(targetBean);
            if (elementBuilder == null) {
                toSet = block.decl((JType)this.context.toJClass(targetType), propertyName, (JExpression)builder.getReadContextVar().invoke("unexpectedXsiType").arg((JExpression)builder.getXSR()).arg(JExpr.dotclass((JClass)this.context.toJClass(targetType))));
            } else {
                JInvocation invocation = this.invokeParser(builder, builder.getChildElementVar(), elementBuilder);
                toSet = block.decl((JType)this.context.toJClass(targetType), propertyName, (JExpression)invocation);
            }
        }
        return toSet;
    }

    private void handleValue(JAXBObjectBuilder builder, JVar xsrVar, JBlock block, Property property, JVar beanVar) {
        JExpression toSet;
        JInvocation value;
        JVar collectionVar = this.handleCollection(builder, property, beanVar);
        if (!property.isCollection()) {
            value = xsrVar.invoke("getElementText");
        } else {
            JForEach forEach = block.forEach((JType)this.context.toJClass(String.class), builder.getReadVariableManager().createId(property.getName() + "Item"), (JExpression)builder.getXSR().invoke("getElementAsXmlList"));
            block = forEach.body();
            value = forEach.var();
        }
        Class targetType = JavaUtils.toClass(property.getComponentType());
        String propertyName = property.getName();
        propertyName = builder.getReadVariableManager().createId(propertyName);
        if (property.getAdapterType() != null) {
            JVar adapterVar = builder.getAdapter(property.getAdapterType());
            JVar xmlValueVar = block.decl((JType)this.context.toJClass(String.class), builder.getReadVariableManager().createId(propertyName + "Raw"), (JExpression)value);
            block.add((JStatement)new JBlankLine());
            JVar valueVar = block.decl((JType)this.context.toJClass(targetType), propertyName, JExpr._null());
            JVar isConvertedVar = block.decl(this.context.toJType(Boolean.TYPE), builder.getReadVariableManager().createId(propertyName + "Converted"));
            JTryBlock tryBlock = block._try();
            tryBlock.body().assign((JAssignmentTarget)valueVar, (JExpression)adapterVar.invoke("unmarshal").arg((JExpression)xmlValueVar));
            tryBlock.body().assign((JAssignmentTarget)isConvertedVar, JExpr.TRUE);
            JCatchBlock catchException = tryBlock._catch(this.context.toJClass(Exception.class));
            JBlock catchBody = catchException.body();
            catchBody.invoke((JExpression)builder.getReadContextVar(), "xmlAdapterError").arg((JExpression)xsrVar).arg(this.context.dotclass(property.getAdapterType())).arg(this.context.dotclass(targetType)).arg(this.context.dotclass(targetType)).arg((JExpression)catchException.param("e"));
            catchBody.assign((JAssignmentTarget)isConvertedVar, JExpr.FALSE);
            block.add((JStatement)new JBlankLine());
            toSet = valueVar;
            block = block._if((JExpression)isConvertedVar)._then();
        } else if (!property.isCollection() && (targetType.equals(Byte.class) || targetType.equals(Byte.TYPE))) {
            toSet = JExpr.cast((JType)this.context.toJType(Byte.TYPE), (JExpression)xsrVar.invoke("getElementAsInt"));
        } else if (this.isBuiltinType(targetType)) {
            toSet = this.coerce(builder, builder.getXSR(), (JExpression)value, targetType);
        } else if (!property.isCollection() && targetType.equals(byte[].class)) {
            toSet = this.context.toJClass(BinaryUtils.class).staticInvoke("decodeAsBytes").arg((JExpression)xsrVar);
        } else if (!property.isCollection() && targetType.equals(QName.class)) {
            toSet = xsrVar.invoke("getElementAsQName");
        } else if (!property.isCollection() && (targetType.equals(DataHandler.class) || targetType.equals(Image.class))) {
            toSet = JExpr._null();
        } else {
            logger.severe("Could not map element value " + propertyName + " of type " + property.getType());
            toSet = JExpr._null();
        }
        this.doSet(builder, block, property, beanVar, toSet, collectionVar);
    }

    private JVar handleCollection(JAXBObjectBuilder builder, Property property, JVar beanVar) {
        JVar collectionVar;
        Class<?> componentType;
        if (!property.isCollection()) {
            return null;
        }
        Class propertyType = JavaUtils.toClass(property.getType());
        JClass collectionType = propertyType.isArray() ? (Boolean.TYPE.equals(componentType = propertyType.getComponentType()) ? this.context.toJClass(ArrayUtil.BooleanArray.class) : (Character.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.CharArray.class) : (Short.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.ShortArray.class) : (Integer.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.IntArray.class) : (Long.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.LongArray.class) : (Float.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.FloatArray.class) : (Double.TYPE.equals(componentType) ? this.context.toJClass(ArrayUtil.DoubleArray.class) : this.context.toJClass(ArrayList.class).narrow(componentType)))))))) : this.context.getGenericType(property.getType());
        String collectionVarName = builder.getReadVariableManager().createId(property.getName());
        JVar collectionAssignment = collectionVar = builder.getReadMethod().body().decl((JType)collectionType, collectionVarName, JExpr._null());
        if (propertyType.isArray()) {
            if (propertyType.getComponentType().isPrimitive()) {
                collectionAssignment = collectionVar.invoke("toArray");
            } else {
                JArray newArray = JExpr.newArray((JType)this.context.toJClass(propertyType.getComponentType()), (JExpression)collectionVar.invoke("size"));
                collectionAssignment = collectionVar.invoke("toArray").arg((JExpression)newArray);
            }
        }
        if (property.getField() != null) {
            Field field = property.getField();
            JBlock assignCollectionBlock = builder.getReadTailBlock()._if(collectionVar.ne(JExpr._null()))._then();
            if (!JavaUtils.isPrivate(field)) {
                assignCollectionBlock.assign((JAssignmentTarget)beanVar.ref(field.getName()), (JExpression)collectionAssignment);
            } else {
                JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                assignCollectionBlock.add((JStatement)fieldAccessorField.invoke("setObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar).arg((JExpression)collectionAssignment));
            }
        } else {
            Method setter = property.getSetter();
            if (setter != null) {
                JBlock assignCollectionBlock = builder.getReadTailBlock()._if(collectionVar.ne(JExpr._null()))._then();
                if (!JavaUtils.isPrivate(setter)) {
                    JTryBlock trySetter = assignCollectionBlock._try();
                    trySetter.body().add((JStatement)beanVar.invoke(setter.getName()).arg((JExpression)collectionAssignment));
                    JCatchBlock catchException = trySetter._catch(this.context.toJClass(Exception.class));
                    catchException.body().invoke((JExpression)builder.getReadContextVar(), "setterError").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(setter.getName()).arg(this.context.dotclass(setter.getParameterTypes()[0])).arg((JExpression)catchException.param("e"));
                } else {
                    JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                    assignCollectionBlock.add((JStatement)propertyAccessorField.invoke("setObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar).arg((JExpression)collectionAssignment));
                }
            }
        }
        return collectionVar;
    }

    private void doSet(JAXBObjectBuilder builder, JBlock block, Property property, JVar beanVar, JExpression toSet, JVar collectionVar) {
        if (toSet == null) {
            return;
        }
        if (property.isId()) {
            JVar id;
            if (toSet instanceof JVar) {
                id = (JVar)toSet;
            } else {
                id = block.decl((JType)this.context.toJClass(String.class), builder.getReadVariableManager().createId(property.getName()), toSet);
                toSet = id;
            }
            block.invoke((JExpression)builder.getReadContextVar(), "addXmlId").arg((JExpression)builder.getXSR()).arg((JExpression)id).arg((JExpression)beanVar);
        }
        if (!property.isCollection()) {
            this.setSingleValue(builder, block, property, beanVar, toSet);
        } else {
            this.addCollectionItem(builder, block, property, beanVar, toSet, collectionVar);
        }
    }

    private void setSingleValue(JAXBObjectBuilder builder, JBlock block, Property property, JVar bean, JExpression value) {
        if (JavaUtils.toClass(property.getComponentType()).isEnum()) {
            block = block._if(value.ne(JExpr._null()))._then();
        }
        if (property.getField() != null) {
            Field field = property.getField();
            if (property.isIdref()) {
                JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                JInvocation target = JExpr._new((JClass)this.context.toJClass(FieldRefTarget.class)).arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)bean).arg((JExpression)fieldAccessorField);
                block.add((JStatement)builder.getReadContextVar().invoke("resolveXmlIdRef").arg((JExpression)builder.getXSR()).arg(value).arg((JExpression)target));
            } else if (!JavaUtils.isPrivate(field)) {
                block.assign((JAssignmentTarget)bean.ref(field.getName()), value);
            } else {
                JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                String methodName = Boolean.TYPE.equals(field.getType()) ? "setBoolean" : (Byte.TYPE.equals(field.getType()) ? "setByte" : (Character.TYPE.equals(field.getType()) ? "setChar" : (Short.TYPE.equals(field.getType()) ? "setShort" : (Integer.TYPE.equals(field.getType()) ? "setInt" : (Long.TYPE.equals(field.getType()) ? "setLong" : (Float.TYPE.equals(field.getType()) ? "setFloat" : (Double.TYPE.equals(field.getType()) ? "setDouble" : "setObject")))))));
                block.add((JStatement)fieldAccessorField.invoke(methodName).arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)bean).arg(value));
            }
        } else if (property.getSetter() != null) {
            Method setter = property.getSetter();
            if (property.isIdref()) {
                JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                JInvocation target = JExpr._new((JClass)this.context.toJClass(FieldRefTarget.class)).arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)bean).arg((JExpression)propertyAccessorField);
                block.add((JStatement)builder.getReadContextVar().invoke("resolveXmlIdRef").arg((JExpression)builder.getXSR()).arg(value).arg((JExpression)target));
            } else if (!JavaUtils.isPrivate(setter)) {
                JTryBlock trySetter = block._try();
                trySetter.body().add((JStatement)bean.invoke(property.getSetter().getName()).arg(value));
                JCatchBlock catchException = trySetter._catch(this.context.toJClass(Exception.class));
                catchException.body().invoke((JExpression)builder.getReadContextVar(), "setterError").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(setter.getName()).arg(this.context.dotclass(setter.getParameterTypes()[0])).arg((JExpression)catchException.param("e"));
            } else {
                JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                block.add((JStatement)propertyAccessorField.invoke("setObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)bean).arg(value));
            }
        } else {
            throw new BuildException("Property does not have a setter: " + property.getBean().getType().getName() + "." + property.getName());
        }
    }

    private void addCollectionItem(JAXBObjectBuilder builder, JBlock block, Property property, JVar beanVar, JExpression toSet, JVar collectionVar) {
        JBlock createCollectionBlock = block._if(collectionVar.eq(JExpr._null()))._then();
        Class propertyType = JavaUtils.toClass(property.getType());
        if (propertyType.isArray()) {
            createCollectionBlock.assign((JAssignmentTarget)collectionVar, (JExpression)JExpr._new((JType)collectionVar.type()));
        } else if (property.getField() == null && property.getGetter() == null) {
            JType collectionType = this.getCollectionClass(property.getType(), property.getComponentType());
            if (collectionType == null) {
                throw new BuildException("Collection property does not have a getter and collection does not have a default constructor: " + property.getBean().getType().getName() + "." + property.getName());
            }
            createCollectionBlock.assign((JAssignmentTarget)collectionVar, (JExpression)JExpr._new((JType)collectionType));
        } else {
            if (property.getField() != null) {
                Field field = property.getField();
                if (!JavaUtils.isPrivate(field)) {
                    createCollectionBlock.assign((JAssignmentTarget)collectionVar, (JExpression)beanVar.ref(field.getName()));
                } else {
                    JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                    createCollectionBlock.assign((JAssignmentTarget)collectionVar, (JExpression)fieldAccessorField.invoke("getObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar));
                }
            } else {
                Method getter = property.getGetter();
                if (!JavaUtils.isPrivate(getter)) {
                    JTryBlock tryGetter = createCollectionBlock._try();
                    tryGetter.body().assign((JAssignmentTarget)collectionVar, (JExpression)beanVar.invoke(getter.getName()));
                    JCatchBlock catchException = tryGetter._catch(this.context.toJClass(Exception.class));
                    catchException.body().invoke((JExpression)builder.getReadContextVar(), "getterError").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(getter.getName()).arg((JExpression)catchException.param("e"));
                    catchException.body()._continue();
                } else {
                    JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                    createCollectionBlock.assign((JAssignmentTarget)collectionVar, (JExpression)propertyAccessorField.invoke("getObject").arg((JExpression)builder.getXSR()).arg((JExpression)builder.getReadContextVar()).arg((JExpression)beanVar));
                }
            }
            JConditional arrayFoundCondition = createCollectionBlock._if(collectionVar.ne(JExpr._null()));
            arrayFoundCondition._then().invoke((JExpression)collectionVar, "clear");
            JType collectionType = this.getCollectionClass(property.getType(), property.getComponentType());
            if (collectionType != null) {
                arrayFoundCondition._else().assign((JAssignmentTarget)collectionVar, (JExpression)JExpr._new((JType)collectionType));
            } else {
                arrayFoundCondition._else().invoke((JExpression)builder.getReadContextVar(), "uncreatableCollection").arg((JExpression)builder.getXSR()).arg(this.context.dotclass(property.getBean().getType())).arg(property.getName()).arg(this.context.dotclass(property.getType()));
                arrayFoundCondition._else()._continue();
            }
        }
        if (property.isIdref()) {
            JInvocation target = JExpr._new((JClass)this.context.toJClass(CollectionRefTarget.class)).arg((JExpression)collectionVar);
            block.add((JStatement)builder.getReadContextVar().invoke("resolveXmlIdRef").arg((JExpression)builder.getXSR()).arg(toSet).arg((JExpression)target));
        } else {
            block.add((JStatement)collectionVar.invoke("add").arg(toSet));
        }
    }

    private JType getCollectionClass(Type collectionType, Type itemType) {
        Class collectionClass = JavaUtils.toClass(collectionType);
        if (!collectionClass.isInterface()) {
            try {
                collectionClass.getConstructor(new Class[0]);
                return this.context.getGenericType(collectionType);
            }
            catch (NoSuchMethodException e) {}
        } else {
            if (SortedSet.class.equals((Object)collectionClass)) {
                return this.context.toJClass(TreeSet.class).narrow(this.context.getGenericType(itemType));
            }
            if (Set.class.equals((Object)collectionClass)) {
                return this.context.toJClass(LinkedHashSet.class).narrow(this.context.getGenericType(itemType));
            }
            if (Queue.class.equals((Object)collectionClass)) {
                return this.context.toJClass(LinkedList.class).narrow(this.context.getGenericType(itemType));
            }
            if (List.class.equals((Object)collectionClass)) {
                return this.context.toJClass(ArrayList.class).narrow(this.context.getGenericType(itemType));
            }
            if (Collection.class.equals((Object)collectionClass)) {
                return this.context.toJClass(ArrayList.class).narrow(this.context.getGenericType(itemType));
            }
        }
        return null;
    }

    private JType getMapClass(Type mapType, Type itemType) {
        Class mapClass = JavaUtils.toClass(mapType);
        if (!mapClass.isInterface()) {
            try {
                mapClass.getConstructor(new Class[0]);
                return this.context.getGenericType(mapType);
            }
            catch (NoSuchMethodException e) {}
        } else if (Map.class.equals((Object)mapClass)) {
            return this.context.toJClass(LinkedHashMap.class).narrow(new JClass[]{this.context.getGenericType((Type)((Object)QName.class)), this.context.getGenericType(itemType)});
        }
        return null;
    }

    private JInvocation newJaxBElement(JVar xsrVar, Class type, JExpression expression) {
        if (JAXBElement.class.equals((Object)type)) {
            throw new IllegalArgumentException("Can't wrap a JAXBElement with a JAXBElement");
        }
        JClass jaxbElementType = this.context.toJClass(JAXBElement.class).narrow(type);
        JInvocation newJaxBElement = JExpr._new((JType)jaxbElementType).arg((JExpression)xsrVar.invoke("getName")).arg(JExpr.dotclass((JClass)this.context.toJClass(type))).arg(expression);
        return newJaxBElement;
    }

    private JVar as(JAXBObjectBuilder builder, JExpression attributeVar, JBlock block, Class<?> cls, String name) {
        return block.decl(this.context.toJType(cls), name, this.coerce(builder, builder.getXSR(), attributeVar, cls));
    }

    private JVar as(JAXBObjectBuilder builder, JVar xsrVar, JBlock block, Class<?> cls, String name, boolean nillable) {
        JVar var;
        JExpression value = this.coerce(builder, xsrVar, (JExpression)xsrVar.invoke("getElementAsString"), cls);
        if (!cls.isPrimitive() && nillable) {
            var = block.decl(this.context.toJType(cls), name, JExpr._null());
            JConditional cond = block._if(xsrVar.invoke("isXsiNil").not());
            cond._then().assign((JAssignmentTarget)var, value);
        } else {
            var = block.decl(this.context.toJType(cls), name, value);
        }
        return var;
    }

    private boolean isBuiltinType(Class type) {
        return type.equals(Boolean.TYPE) || type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(String.class) || type.equals(Boolean.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(XMLGregorianCalendar.class) || type.equals(Duration.class) || type.equals(BigDecimal.class) || type.equals(BigInteger.class) || type.isEnum();
    }

    private JExpression coerce(JAXBObjectBuilder builder, JVar xsrVar, JExpression stringValue, Class<?> destType) {
        if (destType.isPrimitive()) {
            if (destType.equals(Boolean.TYPE)) {
                return JExpr.lit((String)"1").invoke("equals").arg(stringValue).cor((JExpression)JExpr.lit((String)"true").invoke("equals").arg(stringValue));
            }
            if (destType.equals(Byte.TYPE)) {
                return this.context.toJClass(Byte.class).staticInvoke("parseByte").arg(stringValue);
            }
            if (destType.equals(Short.TYPE)) {
                return this.context.toJClass(Short.class).staticInvoke("parseShort").arg(stringValue);
            }
            if (destType.equals(Integer.TYPE)) {
                return this.context.toJClass(Integer.class).staticInvoke("parseInt").arg(stringValue);
            }
            if (destType.equals(Long.TYPE)) {
                return this.context.toJClass(Long.class).staticInvoke("parseLong").arg(stringValue);
            }
            if (destType.equals(Float.TYPE)) {
                return this.context.toJClass(Float.class).staticInvoke("parseFloat").arg(stringValue);
            }
            if (destType.equals(Double.TYPE)) {
                return this.context.toJClass(Double.class).staticInvoke("parseDouble").arg(stringValue);
            }
        } else {
            if (destType.equals(String.class)) {
                return stringValue;
            }
            if (destType.equals(Boolean.class)) {
                return JExpr.lit((String)"1").invoke("equals").arg(stringValue).cor((JExpression)JExpr.lit((String)"true").invoke("equals").arg(stringValue));
            }
            if (destType.equals(Byte.class)) {
                return this.context.toJClass(Byte.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(Short.class)) {
                return this.context.toJClass(Short.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(Integer.class)) {
                return this.context.toJClass(Integer.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(Long.class)) {
                return this.context.toJClass(Long.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(Float.class)) {
                return this.context.toJClass(Float.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(Double.class)) {
                return this.context.toJClass(Double.class).staticInvoke("valueOf").arg(stringValue);
            }
            if (destType.equals(XMLGregorianCalendar.class)) {
                return builder.getDatatypeFactory().invoke("newXMLGregorianCalendar").arg(stringValue);
            }
            if (destType.equals(Duration.class)) {
                return builder.getDatatypeFactory().invoke("newDuration").arg(stringValue);
            }
            if (destType.equals(BigDecimal.class)) {
                return JExpr._new((JClass)this.context.toJClass(BigDecimal.class)).arg(stringValue);
            }
            if (destType.equals(BigInteger.class)) {
                return JExpr._new((JClass)this.context.toJClass(BigInteger.class)).arg(stringValue);
            }
            if (destType.isEnum()) {
                JAXBEnumBuilder enumBuilder = this.enumBuilders.get(destType);
                if (enumBuilder == null) {
                    throw new BuildException("Unknown enum type " + destType);
                }
                return this.invokeEnumParser(builder, xsrVar, enumBuilder, stringValue);
            }
        }
        throw new UnsupportedOperationException("Invalid type " + destType);
    }
}

