/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StaxContentHandler
implements ContentHandler {
    private static final EOF EOF = new EOF();
    private StaxParser staxParser;
    private long timeout;
    private final SynchronousQueue<XMLEvent> queue = new SynchronousQueue();
    private boolean destroyed;
    private final AtomicBoolean shouldClose = new AtomicBoolean(false);
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final LinkedList<List<Namespace>> namespaceStack = new LinkedList();
    private final LinkedList<NamespaceContext> namespaceContext = new LinkedList();
    private List<Namespace> workingNamespaces = new ArrayList<Namespace>();
    private Locator locator;
    private Thread worker;

    public StaxContentHandler() {
        this(null, 5000L);
    }

    public StaxContentHandler(StaxParser staxParser) {
        this(staxParser, 5000L);
    }

    private StaxContentHandler(StaxParser staxParser, long timeout) {
        this.staxParser = staxParser;
        this.timeout = timeout;
        this.eventFactory.setLocation(new SaxLocation());
    }

    public StaxParser getStaxParser() {
        return this.staxParser;
    }

    public void setStaxParser(StaxParser staxParser) {
        this.staxParser = staxParser;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.destroyed) {
            throw new SAXException("StaxContentHandler has been destroyed");
        }
        if (this.worker != null) {
            throw new SAXException("Worker already started");
        }
        this.worker = new Thread((Runnable)new StaxParserWorker(this.staxParser, this.timeout, this.queue, this.shouldClose), "StaxParser-");
        this.worker.setDaemon(true);
        this.worker.start();
        StartDocument event = this.eventFactory.createStartDocument();
        this.postEvent(event);
    }

    private void postEvent(XMLEvent event) throws SAXException {
        if (this.destroyed) {
            return;
        }
        if (this.worker == null) {
            throw new SAXException("No worker thread");
        }
        if (!this.worker.isAlive()) {
            throw new SAXException("Worker thread died");
        }
        if (this.shouldClose.get()) {
            this.destroy();
            return;
        }
        try {
            this.queue.offer(event, this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.worker.interrupt();
            this.worker = null;
            this.destroyed = true;
            throw new SAXException((Exception)e);
        }
    }

    public void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        if (this.worker == null) {
            return;
        }
        if (!this.worker.isAlive()) {
            this.worker = null;
        }
        try {
            this.queue.offer(EOF, this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.worker.interrupt();
            this.worker = null;
            return;
        }
        try {
            this.worker.join(this.timeout);
        }
        catch (InterruptedException e) {
            this.worker.interrupt();
        }
        this.worker = null;
    }

    public void endDocument() throws SAXException {
        if (this.destroyed) {
            return;
        }
        EndDocument event = this.eventFactory.createEndDocument();
        this.postEvent(event);
        this.destroy();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.destroyed) {
            return;
        }
        Namespace namespace = prefix.length() == 0 ? this.eventFactory.createNamespace(uri) : this.eventFactory.createNamespace(prefix, uri);
        this.workingNamespaces.add(namespace);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int i;
        if (this.destroyed) {
            return;
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(atts.getLength());
        for (i = 0; i < atts.getLength(); ++i) {
            String prefix = this.getPrefix(atts.getQName(i));
            if ("xmlns".equals(atts.getQName(i)) || "xmlns".equals(prefix)) continue;
            Attribute attribute = this.eventFactory.createAttribute(prefix, atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            attributes.add(attribute);
        }
        for (i = 0; i < atts.getLength(); ++i) {
            Namespace namespace = "xmlns".equals(atts.getQName(i)) ? this.eventFactory.createNamespace(atts.getValue(i)) : this.eventFactory.createNamespace(atts.getLocalName(i), atts.getValue(i));
            this.workingNamespaces.add(namespace);
        }
        StartElement event = this.eventFactory.createStartElement(this.getPrefix(qName), uri, localName, attributes.iterator(), this.workingNamespaces.iterator(), this.namespaceContext.peek());
        this.namespaceStack.addFirst(this.workingNamespaces);
        this.workingNamespaces = new ArrayList<Namespace>();
        this.namespaceContext.addFirst(event.getNamespaceContext());
        this.postEvent(event);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.destroyed) {
            return;
        }
        if (this.namespaceStack.isEmpty()) {
            throw new SAXException(new IllegalStateException("namespace stack is empty"));
        }
        List<Namespace> namespaces = this.namespaceStack.removeFirst();
        this.workingNamespaces = new ArrayList<Namespace>();
        this.namespaceContext.removeFirst();
        EndElement event = this.eventFactory.createEndElement(this.getPrefix(qName), uri, localName, namespaces.iterator());
        this.postEvent(event);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.destroyed) {
            return;
        }
        Characters event = this.eventFactory.createCharacters(new String(ch, start, length));
        this.postEvent(event);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.destroyed) {
            return;
        }
        Characters event = this.eventFactory.createIgnorableSpace(new String(ch, start, length));
        this.postEvent(event);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.destroyed) {
            return;
        }
        ProcessingInstruction event = this.eventFactory.createProcessingInstruction(target, data);
        this.postEvent(event);
    }

    public void skippedEntity(String name) throws SAXException {
    }

    private String getPrefix(String qname) {
        if (qname == null) {
            return null;
        }
        int index = qname.indexOf(58);
        if (index < 1) {
            return "";
        }
        return qname.substring(0, index);
    }

    private static class EOF
    implements XMLEvent {
        private EOF() {
        }

        public int getEventType() {
            throw new UnsupportedOperationException("EOF");
        }

        public Location getLocation() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isStartElement() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isAttribute() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isNamespace() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isEndElement() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isEntityReference() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isProcessingInstruction() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isCharacters() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isStartDocument() {
            throw new UnsupportedOperationException("EOF");
        }

        public boolean isEndDocument() {
            throw new UnsupportedOperationException("EOF");
        }

        public StartElement asStartElement() {
            throw new UnsupportedOperationException("EOF");
        }

        public EndElement asEndElement() {
            throw new UnsupportedOperationException("EOF");
        }

        public Characters asCharacters() {
            throw new UnsupportedOperationException("EOF");
        }

        public QName getSchemaType() {
            throw new UnsupportedOperationException("EOF");
        }

        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            throw new UnsupportedOperationException("EOF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StaxParserWorker
    implements Runnable {
        private final StaxParser staxParser;
        private final long timeout;
        private final SynchronousQueue<XMLEvent> queue;
        private AtomicBoolean shouldStopNotifier = new AtomicBoolean(false);
        private boolean sawEOF;
        private boolean closed;

        private StaxParserWorker(StaxParser staxParser, long timeout, SynchronousQueue<XMLEvent> queue, AtomicBoolean shouldStopNotifier) {
            this.staxParser = staxParser;
            this.timeout = timeout;
            this.queue = queue;
            this.shouldStopNotifier = shouldStopNotifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.staxParser.parse(new QueueXMLEventReader());
            }
            finally {
                this.shouldStopNotifier.set(true);
                while (!this.sawEOF) {
                    try {
                        XMLEvent event = this.queue.take();
                        if (event != EOF) continue;
                        this.sawEOF = true;
                        continue;
                    }
                    catch (InterruptedException e) {}
                    break;
                }
            }
        }

        public class QueueXMLEventReader
        implements XMLEventReader {
            private XMLEvent current;
            private XMLEvent next;

            private XMLEvent getNext() {
                if (StaxParserWorker.this.closed) {
                    return null;
                }
                if (this.next != null) {
                    return this.next;
                }
                try {
                    this.next = (XMLEvent)StaxParserWorker.this.queue.poll(StaxParserWorker.this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.next == null) {
                    return null;
                }
                if (this.next == EOF) {
                    StaxParserWorker.this.sawEOF = true;
                    return null;
                }
                return this.next;
            }

            public Object next() {
                return this.nextEvent();
            }

            public XMLEvent nextEvent() throws NoSuchElementException {
                if (StaxParserWorker.this.closed) {
                    throw new NoSuchElementException("Stream is closed");
                }
                this.current = this.getNext();
                this.next = null;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                return this.current;
            }

            public boolean hasNext() {
                return this.getNext() != null;
            }

            public XMLEvent peek() throws XMLStreamException {
                if (StaxParserWorker.this.closed) {
                    throw new XMLStreamException("Stream is closed");
                }
                return this.getNext();
            }

            public String getElementText() throws XMLStreamException {
                XMLEvent event;
                if (StaxParserWorker.this.closed) {
                    throw new XMLStreamException("Stream is closed");
                }
                if (!(this.current instanceof StartElement)) {
                    throw new XMLStreamException("Current event must be StartElement, but is " + this.current.getClass().getSimpleName());
                }
                StringBuilder builder = new StringBuilder();
                while (true) {
                    if ((event = this.nextEvent()) instanceof EndElement) {
                        return builder.toString();
                    }
                    if (event instanceof Characters) {
                        Characters characters = (Characters)event;
                        builder.append(characters.getData());
                        continue;
                    }
                    if (!(event instanceof Comment || event instanceof DTD || event instanceof ProcessingInstruction || event instanceof Namespace || event instanceof Attribute)) break;
                }
                throw new XMLStreamException("Encountered XMLEvent event " + event.getClass().getSimpleName());
            }

            public XMLEvent nextTag() throws XMLStreamException {
                XMLEvent event;
                if (StaxParserWorker.this.closed) {
                    throw new XMLStreamException("Stream is closed");
                }
                while (true) {
                    if ((event = this.nextEvent()) instanceof StartElement || event instanceof EndElement) {
                        return event;
                    }
                    if (event instanceof Characters) {
                        Characters characters = (Characters)event;
                        if (characters.isIgnorableWhiteSpace()) continue;
                        throw new XMLStreamException("Encountered non-ignorable whitespace \"" + characters.getData() + "\"");
                    }
                    if (!(event instanceof Comment || event instanceof DTD || event instanceof ProcessingInstruction || event instanceof Namespace || event instanceof Attribute)) break;
                }
                throw new XMLStreamException("Encountered XMLEvent event " + event.getClass().getSimpleName());
            }

            public Object getProperty(String name) throws IllegalArgumentException {
                return null;
            }

            public void close() {
                StaxParserWorker.this.closed = true;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class SaxLocation
    implements Location {
        private SaxLocation() {
        }

        public int getLineNumber() {
            return StaxContentHandler.this.locator.getLineNumber();
        }

        public int getColumnNumber() {
            return StaxContentHandler.this.locator.getColumnNumber();
        }

        public int getCharacterOffset() {
            return -1;
        }

        public String getPublicId() {
            return StaxContentHandler.this.locator.getPublicId();
        }

        public String getSystemId() {
            return StaxContentHandler.this.locator.getSystemId();
        }
    }

    public static interface StaxParser {
        public void parse(XMLEventReader var1);
    }
}

