/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.jaxb.BinaryUtils;
import com.envoisolutions.sxc.jaxb.JAXBIntrospectorImpl;
import com.envoisolutions.sxc.jaxb.JAXBObject;
import com.envoisolutions.sxc.jaxb.RuntimeContext;
import com.envoisolutions.sxc.jaxb.UnmarshallerHandlerImpl;
import com.envoisolutions.sxc.jaxb.ValidationEventLocatorImpl;
import com.envoisolutions.sxc.jaxb.XMLEventStreamReader;
import com.envoisolutions.sxc.util.RuntimeXMLStreamException;
import com.envoisolutions.sxc.util.XoXMLStreamReader;
import com.envoisolutions.sxc.util.XoXMLStreamReaderImpl;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmarshallerImpl
implements Unmarshaller {
    private final JAXBIntrospectorImpl introspector;
    private final XMLInputFactory xif = XMLInputFactory.newInstance();
    private final DatatypeFactory dtFactory;
    private final Map<Class<?>, ? super XmlAdapter> adapters = new HashMap();
    private Unmarshaller.Listener listener;
    private Schema schema;
    private AttachmentUnmarshaller attachmentUnmarshaller;
    private ValidationEventHandler handler;

    public UnmarshallerImpl(JAXBIntrospectorImpl introspector) throws JAXBException {
        this.introspector = introspector;
        try {
            this.dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new JAXBException("Could not create datatype factory.", (Throwable)e);
        }
    }

    private XMLStreamReader createXMLStreamReader(InputSource source) throws UnmarshalException {
        StreamSource streamSource = new StreamSource();
        streamSource.setSystemId(source.getSystemId());
        streamSource.setPublicId(source.getPublicId());
        streamSource.setInputStream(source.getByteStream());
        streamSource.setReader(source.getCharacterStream());
        XMLStreamReader streamReader = this.createXMLStreamReader(streamSource);
        return streamReader;
    }

    private XMLStreamReader createXMLStreamReader(Source source) throws UnmarshalException {
        XMLStreamReader streamReader;
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        try {
            streamReader = this.xif.createXMLStreamReader(source);
        }
        catch (XMLStreamException e) {
            throw new UnmarshalException((Throwable)e);
        }
        return streamReader;
    }

    public Object unmarshal(File file) throws JAXBException {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new StreamSource(file));
        return this.unmarshal(streamReader);
    }

    public Object unmarshal(InputStream inputStream) throws JAXBException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new StreamSource(inputStream));
        return this.unmarshal(streamReader);
    }

    public Object unmarshal(Reader reader) throws JAXBException {
        if (reader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new StreamSource(reader));
        return this.unmarshal(streamReader);
    }

    public Object unmarshal(URL url) throws JAXBException {
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new StreamSource(url.toExternalForm()));
        return this.unmarshal(streamReader);
    }

    public <T> JAXBElement<T> unmarshal(InputSource inputSource, Class<T> declaredType) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException("inputSource is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(inputSource);
        return this.unmarshal(streamReader, declaredType);
    }

    public Object unmarshal(InputSource inputSource) throws JAXBException {
        if (inputSource == null) {
            throw new IllegalArgumentException("inputSource is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(inputSource);
        return this.unmarshal(streamReader);
    }

    public <T> JAXBElement<T> unmarshal(Node node, Class<T> declaredType) throws JAXBException {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new DOMSource(node));
        return this.unmarshal(streamReader, declaredType);
    }

    public Object unmarshal(Node node) throws JAXBException {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(new DOMSource(node));
        return this.unmarshal(streamReader);
    }

    public <T> JAXBElement<T> unmarshal(Source source, Class<T> declaredType) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType is null");
        }
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            return (JAXBElement)this.unmarshal2(saxSource, declaredType);
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(source);
        return this.unmarshal(streamReader, declaredType);
    }

    public Object unmarshal(Source source) throws JAXBException {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            return this.unmarshal(saxSource, null);
        }
        XMLStreamReader streamReader = this.createXMLStreamReader(source);
        return this.unmarshal(streamReader);
    }

    private Object unmarshal2(SAXSource saxSource, Class<?> declaredType) throws JAXBException {
        if (saxSource == null) {
            throw new IllegalArgumentException("saxSource is null");
        }
        InputSource inputSource = saxSource.getInputSource();
        if (inputSource == null) {
            throw new UnmarshalException("source.getInputSource() is null");
        }
        XMLReader xmlReader = saxSource.getXMLReader();
        if (xmlReader == null) {
            if (declaredType != null) {
                return this.unmarshal(inputSource, declaredType);
            }
            return this.unmarshal(inputSource);
        }
        UnmarshallerHandlerImpl unmarshallerHandler = this.getUnmarshallerHandler();
        unmarshallerHandler.setType(declaredType);
        xmlReader.setContentHandler(unmarshallerHandler);
        try {
            xmlReader.parse(inputSource);
        }
        catch (Exception e) {
            throw new JAXBException("Error reading XML stream.", (Throwable)e);
        }
        return unmarshallerHandler.getResult();
    }

    public <T> JAXBElement<T> unmarshal(XMLEventReader xmlEventReader, Class<T> declaredType) throws JAXBException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("xmlEventReader is null");
        }
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType is null");
        }
        XMLEventStreamReader streamReader = new XMLEventStreamReader(xmlEventReader);
        return this.unmarshal(streamReader, declaredType);
    }

    public Object unmarshal(XMLEventReader xmlEventReader) throws JAXBException {
        if (xmlEventReader == null) {
            throw new IllegalArgumentException("xmlEventReader is null");
        }
        XMLEventStreamReader streamReader = new XMLEventStreamReader(xmlEventReader);
        return this.unmarshal(streamReader);
    }

    public <T> JAXBElement<T> unmarshal(XMLStreamReader xmlStreamReader, Class<T> declaredType) throws JAXBException {
        if (xmlStreamReader == null) {
            throw new IllegalArgumentException("xmlStreamReader is null");
        }
        if (declaredType == null) {
            throw new IllegalArgumentException("declaredType is null");
        }
        RuntimeContext runtimeContext = new RuntimeContext(this);
        JAXBElement element = (JAXBElement)this.read(xmlStreamReader, declaredType, true, runtimeContext);
        runtimeContext.resolveXmlIdRefs();
        return element;
    }

    public Object unmarshal(XMLStreamReader xmlStreamReader) throws JAXBException {
        if (xmlStreamReader == null) {
            throw new IllegalArgumentException("xmlStreamReader is null");
        }
        RuntimeContext runtimeContext = new RuntimeContext(this);
        Object value = this.read(xmlStreamReader, null, null, runtimeContext);
        runtimeContext.resolveXmlIdRefs();
        return value;
    }

    public Object read(XMLStreamReader xmlStreamReader, Class<?> declaredType, Boolean jaxbElementWrap, RuntimeContext runtimeContext) throws JAXBException {
        if (xmlStreamReader == null) {
            throw new IllegalArgumentException("xmlStreamReader is null");
        }
        if (runtimeContext == null) {
            throw new IllegalArgumentException("runtimeContext is null");
        }
        XoXMLStreamReaderImpl reader = new XoXMLStreamReaderImpl(xmlStreamReader);
        try {
            int event = reader.getEventType();
            while (event != 1 && reader.hasNext()) {
                event = reader.next();
            }
            if (event != 1) {
                return null;
            }
            QName name = reader.getName();
            Object o = null;
            if (reader.isXsiNil()) {
                return null;
            }
            if (reader.getXsiType() != null) {
                JAXBObject instance = this.introspector.getJaxbMarshallerBySchemaType(reader.getXsiType());
                if (instance != null) {
                    if (declaredType == null) {
                        declaredType = Object.class;
                    }
                    if (jaxbElementWrap == null) {
                        jaxbElementWrap = instance.getXmlRootElement() == null;
                    }
                    if (declaredType.isAssignableFrom(instance.getType())) {
                        o = instance.read((XoXMLStreamReader)reader, runtimeContext);
                    } else {
                        String message = "Expected instance of " + declaredType.getName() + ", but found xsi:type " + reader.getXsiType() + " which is mapped to " + instance.getType().getName();
                        if (this.getEventHandler() == null || !this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)new ValidationEventLocatorImpl(reader.getLocation())))) {
                            throw new UnmarshalException(message);
                        }
                        jaxbElementWrap = false;
                    }
                } else {
                    String message = "No JAXB object for XML type " + reader.getXsiType();
                    if (this.getEventHandler() == null || !this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)new ValidationEventLocatorImpl(reader.getLocation())))) {
                        throw new UnmarshalException(message);
                    }
                    jaxbElementWrap = false;
                }
            } else if (declaredType != null && !Object.class.equals(declaredType)) {
                if (String.class.equals(declaredType)) {
                    o = reader.getElementAsString();
                } else if (Boolean.class.equals(declaredType)) {
                    o = reader.getElementAsBoolean();
                } else if (Double.class.equals(declaredType)) {
                    o = reader.getElementAsDouble();
                } else if (Long.class.equals(declaredType)) {
                    o = reader.getElementAsLong();
                } else if (Float.class.equals(declaredType)) {
                    o = Float.valueOf(reader.getElementAsFloat());
                } else if (Short.class.equals(declaredType)) {
                    o = reader.getElementAsShort();
                } else if (QName.class.equals(declaredType)) {
                    o = reader.getElementAsQName();
                } else if (byte[].class.equals(declaredType)) {
                    o = BinaryUtils.decodeAsBytes((XMLStreamReader)reader);
                } else if (XMLGregorianCalendar.class.equals(declaredType)) {
                    String s = reader.getElementAsString();
                    o = this.dtFactory.newXMLGregorianCalendar(s);
                } else if (Duration.class.equals(declaredType)) {
                    String s = reader.getElementAsString();
                    o = this.dtFactory.newDuration(s);
                } else if (Node.class.equals(declaredType)) {
                    Element element = reader.getElementAsDomElement();
                    o = element;
                } else {
                    JAXBObject<Object> instance = this.introspector.getJaxbMarshaller(declaredType);
                    if (instance != null) {
                        if (declaredType == null) {
                            declaredType = Object.class;
                        }
                        if (jaxbElementWrap == null) {
                            jaxbElementWrap = instance.getXmlRootElement() == null;
                        }
                        o = instance.read((XoXMLStreamReader)reader, runtimeContext);
                    } else {
                        String message = declaredType.getName() + " is not a JAXB object";
                        if (this.getEventHandler() == null || !this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)new ValidationEventLocatorImpl(reader.getLocation())))) {
                            throw new UnmarshalException(message);
                        }
                        jaxbElementWrap = false;
                    }
                }
            } else {
                JAXBObject instance = this.introspector.getJaxbMarshallerByElementName(name);
                if (instance != null) {
                    if (jaxbElementWrap == null) {
                        jaxbElementWrap = instance.getXmlRootElement() == null;
                    }
                    declaredType = Object.class;
                    o = instance.read((XoXMLStreamReader)reader, runtimeContext);
                } else if (Object.class.equals(declaredType)) {
                    Element element = reader.getElementAsDomElement();
                    o = element;
                } else {
                    String message = "No JAXB object mapped to root element " + name + "; known root elemnts are " + this.introspector.getElementNames();
                    if (this.getEventHandler() == null || !this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(1, message, (ValidationEventLocator)new ValidationEventLocatorImpl(reader.getLocation())))) {
                        throw new UnmarshalException(message);
                    }
                    jaxbElementWrap = false;
                }
            }
            if (jaxbElementWrap != null && jaxbElementWrap.booleanValue()) {
                return new JAXBElement(name, declaredType, o);
            }
            return o;
        }
        catch (Exception e2) {
            XMLStreamException e2;
            if (e2 instanceof RuntimeXMLStreamException) {
                e2 = ((RuntimeXMLStreamException)e2).getCause();
            }
            if (e2 instanceof XMLStreamException) {
                Throwable cause = e2.getCause();
                if (cause instanceof JAXBException) {
                    throw (JAXBException)((Object)e2);
                }
                throw new UnmarshalException(cause == null ? e2 : cause);
            }
            if (e2 instanceof JAXBException) {
                throw (JAXBException)((Object)e2);
            }
            if (this.getEventHandler() != null) {
                this.getEventHandler().handleEvent((ValidationEvent)new ValidationEventImpl(2, "Fatal error", (ValidationEventLocator)new ValidationEventLocatorImpl(reader.getLocation()), (Throwable)e2));
            }
            throw new UnmarshalException((Throwable)e2);
        }
    }

    public Unmarshaller.Listener getListener() {
        return this.listener;
    }

    public void setListener(Unmarshaller.Listener listener) {
        this.listener = listener;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.handler;
    }

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        if (handler == null) {
            handler = new DefaultValidationEventHandler();
        }
        this.handler = handler;
    }

    public <A extends XmlAdapter> A getAdapter(Class<A> type) {
        return (A)this.adapters.get(type);
    }

    public void setAdapter(XmlAdapter adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("adapter is null");
        }
        this.setAdapter(adapter.getClass(), adapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> type, A adapter) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (adapter != null) {
            this.adapters.put(type, adapter);
        } else {
            this.adapters.remove(type);
        }
    }

    public AttachmentUnmarshaller getAttachmentUnmarshaller() {
        return this.attachmentUnmarshaller;
    }

    public void setAttachmentUnmarshaller(AttachmentUnmarshaller attachmentUnmarshaller) {
        this.attachmentUnmarshaller = attachmentUnmarshaller;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public UnmarshallerHandlerImpl getUnmarshallerHandler() {
        return new UnmarshallerHandlerImpl(this);
    }

    public Object getProperty(String name) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        throw new PropertyException(name);
    }

    public void setProperty(String name, Object value) throws PropertyException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        throw new PropertyException(name, value);
    }

    public boolean isValidating() throws JAXBException {
        return false;
    }

    public void setValidating(boolean validating) throws JAXBException {
    }
}

