/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import com.envoisolutions.sxc.builder.BuildException;
import com.envoisolutions.sxc.builder.impl.JBlankLine;
import com.envoisolutions.sxc.builder.impl.JIfElseBlock;
import com.envoisolutions.sxc.builder.impl.JLineComment;
import com.envoisolutions.sxc.builder.impl.JStaticImports;
import com.envoisolutions.sxc.jaxb.BinaryUtils;
import com.envoisolutions.sxc.jaxb.BuilderContext;
import com.envoisolutions.sxc.jaxb.JAXBEnumBuilder;
import com.envoisolutions.sxc.jaxb.JAXBObjectBuilder;
import com.envoisolutions.sxc.jaxb.JavaUtils;
import com.envoisolutions.sxc.jaxb.model.Bean;
import com.envoisolutions.sxc.jaxb.model.ElementMapping;
import com.envoisolutions.sxc.jaxb.model.EnumInfo;
import com.envoisolutions.sxc.jaxb.model.Model;
import com.envoisolutions.sxc.jaxb.model.Property;
import com.envoisolutions.sxc.util.Base64;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.awt.Image;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterIntrospector {
    private static final Logger logger = Logger.getLogger(WriterIntrospector.class.getName());
    private final BuilderContext context;
    private final Model model;
    private final Map<Bean, JAXBObjectBuilder> builders = new LinkedHashMap<Bean, JAXBObjectBuilder>();
    private final Map<Class, JAXBEnumBuilder> enumBuilders = new LinkedHashMap<Class, JAXBEnumBuilder>();

    public WriterIntrospector(BuilderContext context, Model model) throws JAXBException {
        this.context = context;
        this.model = model;
        ArrayList<Bean> mybeans = new ArrayList<Bean>(model.getBeans());
        Collections.sort(mybeans, new BeanComparator());
        for (EnumInfo enumInfo : model.getEnums()) {
            this.addEnum(enumInfo);
        }
        for (Bean bean : mybeans) {
            if (bean.getType().isEnum()) continue;
            boolean mixed = false;
            for (Property property : bean.getProperties()) {
                if (!property.isMixed() || property.getXmlName() != null) continue;
                mixed = true;
                break;
            }
            JAXBObjectBuilder builder = context.createJAXBObjectBuilder(bean.getType(), bean.getRootElementName(), bean.getSchemaTypeName(), mixed);
            LinkedHashSet<Property> allProperties = new LinkedHashSet<Property>();
            for (Bean b = bean; b != null; b = b.getBaseClass()) {
                allProperties.addAll(b.getProperties());
            }
            String mostPopularNS = this.getMostPopularNS(allProperties);
            if (mostPopularNS != null) {
                builder.setWriterDefaultNS(mostPopularNS);
            }
            for (Property property : allProperties) {
                Field field = property.getField();
                if (field != null) {
                    if (!JavaUtils.isPrivate(field)) continue;
                    builder.getPrivateFieldAccessor(property.getField());
                    continue;
                }
                if (!JavaUtils.isPrivate(property.getGetter()) && !JavaUtils.isPrivate(property.getSetter())) continue;
                builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
            }
            for (Property property : allProperties) {
                if (property.getAdapterType() == null) continue;
                builder.getAdapter(property.getAdapterType());
            }
            this.builders.put(bean, builder);
        }
        for (Bean bean : model.getBeans()) {
            JAXBObjectBuilder builder;
            if (bean.getType().isEnum() || (builder = this.builders.get(bean)) == null) continue;
            this.add(builder, bean);
        }
    }

    private void add(JAXBObjectBuilder builder, Bean bean) {
        JBlock block = builder.getWriteMethod().body();
        JIfElseBlock ifElseBlock = new JIfElseBlock();
        block.add((JStatement)ifElseBlock);
        JInvocation unexpectedSubclass = builder.getWriteContextVar().invoke("unexpectedSubclass").arg((JExpression)builder.getXSW()).arg((JExpression)builder.getWriteObject()).arg(this.context.dotclass(bean.getType()));
        for (Bean altBean : this.getSubstitutionTypes(builder.getType())) {
            if (bean == altBean) continue;
            JBlock altBlock = ifElseBlock.addCondition(this.context.dotclass(altBean.getType()).eq((JExpression)builder.getWriteObject().invoke("getClass")));
            QName typeName = altBean.getSchemaTypeName();
            altBlock.invoke((JExpression)builder.getXSW(), "writeXsiType").arg(typeName.getNamespaceURI()).arg(typeName.getLocalPart());
            this.writeClassWriter(builder, altBean, altBlock, (JExpression)JExpr.cast((JType)this.context.toJClass(altBean.getType()), (JExpression)builder.getWriteObject()));
            altBlock._return();
            unexpectedSubclass.arg(this.context.dotclass(altBean.getType()));
        }
        JBlock unknownSubclassBlock = ifElseBlock.addCondition(this.context.dotclass(builder.getType()).ne((JExpression)builder.getWriteObject().invoke("getClass")));
        unknownSubclassBlock.add((JStatement)unexpectedSubclass);
        unknownSubclassBlock._return();
        block.add((JStatement)new JBlankLine());
        JFieldVar lifecycleCallbackRef = builder.getLifecycleCallbackVar();
        if (builder.getWriteVariableManager().containsId(builder.getLifecycleCallbackVar().name())) {
            lifecycleCallbackRef = builder.getJAXBObjectClass().staticRef(builder.getLifecycleCallbackVar().name());
        }
        block.invoke((JExpression)builder.getWriteContextVar(), "beforeMarshal").arg((JExpression)builder.getWriteObject()).arg((JExpression)lifecycleCallbackRef);
        block.add((JStatement)new JBlankLine());
        this.writeProperties(builder, bean);
    }

    private void addEnum(EnumInfo enumInfo) {
        JAXBEnumBuilder builder = this.context.createJAXBEnumBuilder(enumInfo.getType(), enumInfo.getRootElementName(), enumInfo.getSchemaTypeName());
        JMethod method = builder.getToStringMethod();
        JIfElseBlock enumSwitch = new JIfElseBlock();
        method.body().add((JStatement)enumSwitch);
        for (Map.Entry<Enum, String> entry : enumInfo.getEnumMap().entrySet()) {
            Enum enumValue = entry.getKey();
            String enumText = entry.getValue();
            JBlock enumCase = enumSwitch.addCondition(this.context.toJClass(enumInfo.getType()).staticRef(enumValue.name()).eq((JExpression)builder.getToStringValue()));
            enumCase._return(JExpr.lit((String)enumText));
        }
        JInvocation unexpectedInvoke = enumSwitch._else().invoke((JExpression)builder.getToStringContext(), "unexpectedEnumConst").arg((JExpression)builder.getToStringBean()).arg((JExpression)builder.getToStringParameterName()).arg((JExpression)builder.getToStringValue());
        for (Enum expectedValue : enumInfo.getEnumMap().keySet()) {
            unexpectedInvoke.arg((JExpression)this.context.toJClass(enumInfo.getType()).staticRef(expectedValue.name()));
        }
        enumSwitch._else()._return(JExpr._null());
        this.enumBuilders.put(enumInfo.getType(), builder);
    }

    private void writeProperties(JAXBObjectBuilder builder, Bean bean) {
        this.writeAttributes(builder, bean);
        this.writeElementsAndValue(builder, bean);
    }

    private void writeAttributes(JAXBObjectBuilder builder, Bean bean) {
        if (bean.getBaseClass() != null) {
            this.writeAttributes(builder, bean.getBaseClass());
        }
        for (Property property : bean.getProperties()) {
            ParameterizedType parameterizedType;
            Type[] arguments;
            JConditional nullCond;
            if (property.getXmlStyle() != Property.XmlStyle.ATTRIBUTE) continue;
            JBlock block = builder.getWriteMethod().body();
            block.add((JStatement)new JBlankLine());
            block.add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
            JVar propertyVar = this.getValue(builder, property, block);
            if (!property.isXmlAny()) {
                if (!JavaUtils.toClass(property.getType()).isPrimitive()) {
                    nullCond = block._if(propertyVar.ne(JExpr._null()));
                    block = nullCond._then();
                }
                this.writeSimpleTypeAttribute(builder, block, property, (JExpression)propertyVar);
                continue;
            }
            nullCond = block._if(propertyVar.ne(JExpr._null()));
            String entryName = builder.getWriteVariableManager().createId(property.getName() + "Entry");
            boolean needsCast = true;
            if (property.getType() instanceof ParameterizedType && (arguments = (parameterizedType = (ParameterizedType)property.getType()).getActualTypeArguments()).length == 2 && QName.class.equals((Object)arguments[0]) && property.getComponentType().equals(arguments[1])) {
                needsCast = false;
            }
            if (needsCast) {
                propertyVar = JExpr.cast((JType)this.context.toJClass(Map.class).narrow(new JClass[]{this.context.toJClass(QName.class), this.context.getGenericType(property.getComponentType())}), (JExpression)propertyVar);
            }
            JForEach each = nullCond._then().forEach((JType)this.context.toJClass(Map.Entry.class).narrow(new JClass[]{this.context.toJClass(QName.class), this.context.getGenericType(property.getComponentType())}), entryName, (JExpression)propertyVar.invoke("entrySet"));
            this.writeSimpleTypeAttribute(builder, each.body(), (JExpression)each.var().invoke("getKey"), JavaUtils.toClass(property.getComponentType()), (JExpression)each.var().invoke("getValue"));
        }
    }

    private void writeElementsAndValue(JAXBObjectBuilder builder, Bean bean) {
        if (bean.getBaseClass() != null) {
            this.writeElementsAndValue(builder, bean.getBaseClass());
        }
        block5: for (Property property : bean.getProperties()) {
            if (property.getXmlStyle() == Property.XmlStyle.ATTRIBUTE) continue;
            builder.getWriteMethod().body().add((JStatement)new JBlankLine());
            builder.getWriteMethod().body().add((JStatement)new JLineComment((Object)((Object)property.getXmlStyle()) + ": " + property.getName()));
            JVar propertyVar = this.getValue(builder, property, builder.getWriteMethod().body());
            switch (property.getXmlStyle()) {
                case ELEMENT: {
                    String itemName;
                    JVar outerVar = propertyVar;
                    JBlock outerBlock = builder.getWriteMethod().body();
                    JVar firstVar = null;
                    if (property.isCollection()) {
                        QName wrapperElement = property.getXmlName();
                        if (wrapperElement != null && (property.isRequired() || property.isNillable())) {
                            outerBlock.add((JStatement)builder.getWriteStartElement(wrapperElement));
                        }
                        JConditional nullCond = outerBlock._if(outerVar.ne(JExpr._null()));
                        if (property.isNillable()) {
                            nullCond._else().add((JStatement)builder.getXSW().invoke("writeXsiNil"));
                        }
                        if (wrapperElement != null && !property.isRequired() && !property.isNillable()) {
                            nullCond._then().add((JStatement)builder.getWriteStartElement(wrapperElement));
                        }
                        Object itemType = !JavaUtils.toClass(property.getComponentType()).isPrimitive() ? this.context.getGenericType(property.getComponentType()) : this.context.toJType(JavaUtils.toClass(property.getComponentType()));
                        if (property.isXmlList()) {
                            firstVar = nullCond._then().decl(this.context.toJType(Boolean.TYPE), builder.getWriteVariableManager().createId(property.getName() + "First"), JExpr.TRUE);
                        }
                        String itemName2 = builder.getWriteVariableManager().createId(property.getName() + "Item");
                        JForEach each = nullCond._then().forEach((JType)itemType, itemName2, (JExpression)outerVar);
                        if (wrapperElement != null) {
                            if (property.isRequired() || property.isNillable()) {
                                outerBlock.add((JStatement)builder.getXSW().invoke("writeEndElement"));
                            } else {
                                nullCond._then().add((JStatement)builder.getXSW().invoke("writeEndElement"));
                            }
                        }
                        outerBlock = each.body();
                        outerVar = each.var();
                    }
                    Class propertyType = JavaUtils.toClass(property.getComponentType());
                    outerVar = this.writeAdapterConversion(builder, outerBlock, property, outerVar);
                    if (property.getAdapterType() != null) {
                        propertyType = property.getComponentAdaptedType();
                    }
                    TreeMap<Class, ElementMapping> expectedTypes = new TreeMap<Class, ElementMapping>(new ClassComparator());
                    for (ElementMapping mapping : property.getElementMappings()) {
                        if (mapping.getComponentType() != null) {
                            expectedTypes.put(JavaUtils.toClass(mapping.getComponentType()), mapping);
                            continue;
                        }
                        expectedTypes.put(JavaUtils.toClass(property.getType()), mapping);
                    }
                    if (expectedTypes.size() == 1 && !property.isMixed()) {
                        ElementMapping mapping = property.getElementMappings().iterator().next();
                        JBlock block = outerBlock;
                        JConditional nullCond = null;
                        if (!mapping.isNillable() && !propertyType.isPrimitive()) {
                            nullCond = outerBlock._if(outerVar.ne(JExpr._null()));
                            block = nullCond._then();
                        }
                        if (property.isXmlList()) {
                            block._if(firstVar.not())._then().add((JStatement)builder.getXSW().invoke("writeCharacters").arg(" "));
                            block.assign((JAssignmentTarget)firstVar, JExpr.FALSE);
                        }
                        this.writeElement(builder, block, mapping, outerVar, propertyType, mapping.isNillable(), property.isXmlList());
                        if (!property.isRequired() || mapping.isNillable() || nullCond == null) continue block5;
                        nullCond._else().invoke((JExpression)builder.getWriteContextVar(), "unexpectedNullValue").arg((JExpression)builder.getWriteObject()).arg(property.getName());
                        break;
                    }
                    JIfElseBlock conditional = new JIfElseBlock();
                    outerBlock.add((JStatement)conditional);
                    if (property.isMixed()) {
                        JVar itemVar;
                        JExpression isInstance = outerVar._instanceof((JType)this.context.toJClass(String.class));
                        JBlock block = conditional.addCondition(isInstance);
                        if (JavaUtils.toClass(property.getComponentType()) == String.class) {
                            itemVar = outerVar;
                        } else {
                            itemName = builder.getWriteVariableManager().createId("string");
                            itemVar = block.decl((JType)this.context.toJClass(String.class), itemName, (JExpression)JExpr.cast((JType)this.context.toJClass(String.class), (JExpression)outerVar));
                        }
                        this.writeSimpleTypeElement(builder, (JExpression)itemVar, String.class, block);
                    }
                    ElementMapping nilMapping = null;
                    for (Map.Entry entry : expectedTypes.entrySet()) {
                        JVar itemVar;
                        Class itemType = (Class)entry.getKey();
                        ElementMapping mapping = (ElementMapping)entry.getValue();
                        if (mapping.isNillable()) {
                            if (nilMapping != null && nilMapping != mapping) {
                                throw new BuildException("Property " + property + " mappings " + mapping.getXmlName() + " and " + nilMapping + " are both nillable.  Only one mapping may of an property may be nilable");
                            }
                            nilMapping = mapping;
                        }
                        JExpression isInstance = outerVar._instanceof((JType)this.context.toJClass(itemType));
                        JBlock block = conditional.addCondition(isInstance);
                        if (property.isXmlList()) {
                            block._if(firstVar.not())._then().add((JStatement)builder.getXSW().invoke("writeCharacters").arg(" "));
                            block.assign((JAssignmentTarget)firstVar, JExpr.FALSE);
                        }
                        if (JavaUtils.toClass(property.getComponentType()) == itemType) {
                            itemVar = outerVar;
                        } else {
                            String itemName3 = builder.getWriteVariableManager().createId(itemType.getSimpleName());
                            itemVar = block.decl((JType)this.context.toJClass(itemType), itemName3, (JExpression)JExpr.cast((JType)this.context.toJClass(itemType), (JExpression)outerVar));
                        }
                        this.writeElement(builder, block, mapping, itemVar, itemType, false, property.isXmlList());
                    }
                    JBlock nullBlock = conditional.addCondition(outerVar.eq(JExpr._null()));
                    if (nilMapping != null) {
                        QName name = nilMapping.getXmlName();
                        nullBlock.add((JStatement)builder.getWriteStartElement(name));
                        nullBlock.add((JStatement)builder.getXSW().invoke("writeXsiNil"));
                        nullBlock.add((JStatement)builder.getXSW().invoke("writeEndElement"));
                    } else {
                        nullBlock.invoke((JExpression)builder.getWriteContextVar(), "unexpectedNullValue").arg((JExpression)builder.getWriteObject()).arg(property.getName());
                    }
                    JInvocation unexpected = conditional._else().invoke((JExpression)builder.getWriteContextVar(), "unexpectedElementType").arg((JExpression)builder.getXSW()).arg((JExpression)builder.getWriteObject()).arg(property.getName()).arg((JExpression)outerVar);
                    for (Class expectedType : expectedTypes.keySet()) {
                        unexpected.arg(this.context.dotclass(expectedType));
                    }
                    continue block5;
                }
                case ELEMENT_REF: {
                    JBlock newBody;
                    JForEach each;
                    Object itemType;
                    JBlock collectionNotNull;
                    String itemName;
                    JBlock block = builder.getWriteMethod().body();
                    JVar itemVar = propertyVar;
                    if (property.isCollection()) {
                        collectionNotNull = block._if(propertyVar.ne(JExpr._null()))._then();
                        itemType = !JavaUtils.toClass(property.getComponentType()).isPrimitive() ? this.context.getGenericType(property.getComponentType()) : this.context.toJType(JavaUtils.toClass(property.getComponentType()));
                        itemName = builder.getWriteVariableManager().createId(property.getName() + "Item");
                        each = collectionNotNull.forEach((JType)itemType, itemName, (JExpression)propertyVar);
                        block = newBody = each.body();
                        itemVar = each.var();
                    }
                    itemVar = this.writeAdapterConversion(builder, block, property, itemVar);
                    if (property.isMixed()) {
                        JVar stringVar;
                        JExpression isInstance = itemVar._instanceof((JType)this.context.toJClass(String.class));
                        JConditional conditional = block._if(isInstance);
                        if (JavaUtils.toClass(property.getComponentType()) == String.class) {
                            stringVar = itemVar;
                        } else {
                            String itemName4 = builder.getWriteVariableManager().createId("string");
                            stringVar = conditional._then().decl((JType)this.context.toJClass(String.class), itemName4, (JExpression)JExpr.cast((JType)this.context.toJClass(String.class), (JExpression)itemVar));
                        }
                        this.writeSimpleTypeElement(builder, (JExpression)stringVar, String.class, conditional._then());
                        block = conditional._else();
                    }
                    if (!property.isXmlAny()) {
                        block.invoke((JExpression)builder.getWriteContextVar(), "unexpectedElementRef").arg((JExpression)builder.getXSW()).arg((JExpression)builder.getWriteObject()).arg(property.getName()).arg((JExpression)itemVar);
                        break;
                    }
                    block.invoke((JExpression)builder.getWriteContextVar(), "writeXmlAny").arg((JExpression)builder.getXSW()).arg((JExpression)builder.getWriteObject()).arg(property.getName()).arg((JExpression)itemVar);
                    break;
                }
                case VALUE: {
                    JBlock newBody;
                    JForEach each;
                    Object itemType;
                    JBlock collectionNotNull;
                    String itemName;
                    JBlock block = builder.getWriteMethod().body();
                    JVar itemVar = propertyVar;
                    JVar firstVar = null;
                    if (property.isCollection()) {
                        collectionNotNull = block._if(propertyVar.ne(JExpr._null()))._then();
                        itemType = !JavaUtils.toClass(property.getComponentType()).isPrimitive() ? this.context.getGenericType(property.getComponentType()) : this.context.toJType(JavaUtils.toClass(property.getComponentType()));
                        firstVar = collectionNotNull.decl(this.context.toJType(Boolean.TYPE), builder.getWriteVariableManager().createId(property.getName() + "First"), JExpr.TRUE);
                        itemName = builder.getWriteVariableManager().createId(property.getName() + "Item");
                        each = collectionNotNull.forEach((JType)itemType, itemName, (JExpression)propertyVar);
                        block = newBody = each.body();
                        itemVar = each.var();
                    }
                    if (property.isCollection()) {
                        block._if(firstVar.not())._then().add((JStatement)builder.getXSW().invoke("writeCharacters").arg(" "));
                        block.assign(firstVar, JExpr.FALSE);
                    }
                    propertyVar = this.writeAdapterConversion(builder, block, property, itemVar);
                    this.writeSimpleTypeElement(builder, (JExpression)propertyVar, JavaUtils.toClass(property.getComponentType()), block);
                    break;
                }
                default: {
                    throw new BuildException("Unknown XmlMapping type " + (Object)((Object)property.getXmlStyle()));
                }
            }
        }
    }

    private void writeElement(JAXBObjectBuilder builder, JBlock block, ElementMapping mapping, JVar itemVar, Class type, boolean nillable, boolean xmlList) {
        Bean targetBean;
        if (mapping.getProperty().isIdref()) {
            Property property = mapping.getProperty();
            Property idProperty = this.findReferencedIdProperty(property);
            itemVar = this.getValue(builder, (JExpression)itemVar, idProperty, property.getName() + JavaUtils.capitalize(idProperty.getName()), block);
            type = String.class;
            nillable = false;
            JConditional nullCond = block._if(itemVar.ne(JExpr._null()));
            block = nullCond._then();
        }
        if (!xmlList) {
            QName name = mapping.getXmlName();
            block.add((JStatement)builder.getWriteStartElement(name));
        }
        JBlock elementWriteBlock = block;
        if (nillable && !type.isPrimitive() && !xmlList) {
            JConditional nilCond = block._if(itemVar.ne(JExpr._null()));
            elementWriteBlock = nilCond._then();
            nilCond._else().add((JStatement)builder.getXSW().invoke("writeXsiNil"));
        }
        if ((targetBean = this.model.getBean(type)) == null || targetBean.getType().isEnum()) {
            this.writeSimpleTypeElement(builder, (JExpression)itemVar, type, elementWriteBlock);
        } else {
            if (!mapping.getComponentType().equals(type)) {
                QName typeName = targetBean.getSchemaTypeName();
                elementWriteBlock.add((JStatement)builder.getXSW().invoke("writeXsiType").arg(typeName.getNamespaceURI()).arg(typeName.getLocalPart()));
            }
            this.writeClassWriter(builder, targetBean, elementWriteBlock, (JExpression)itemVar);
        }
        if (!xmlList) {
            block.add((JStatement)builder.getXSW().invoke("writeEndElement"));
        }
    }

    private JVar getValue(JAXBObjectBuilder builder, Property property, JBlock block) {
        return this.getValue(builder, (JExpression)builder.getWriteObject(), property, block);
    }

    private JVar getValue(JAXBObjectBuilder builder, JExpression beanVar, Property property, JBlock block) {
        String propertyName = property.getName();
        if (property.getAdapterType() != null) {
            propertyName = propertyName + "Raw";
        }
        return this.getValue(builder, beanVar, property, propertyName, block);
    }

    private JVar getValue(JAXBObjectBuilder builder, JExpression beanVar, Property property, String propertyNameHint, JBlock block) {
        Class propertyType = JavaUtils.toClass(property.getType());
        String propertyName = builder.getWriteVariableManager().createId(propertyNameHint);
        JVar propertyVar = block.decl((JType)this.context.getGenericType(property.getType()), propertyName);
        if (property.getField() != null) {
            Field field = property.getField();
            if (!JavaUtils.isPrivate(field)) {
                propertyVar.init((JExpression)beanVar.ref(field.getName()));
            } else {
                JFieldVar fieldAccessorField = builder.getPrivateFieldAccessor(field);
                String methodName = Boolean.TYPE.equals(propertyType) ? "getBoolean" : (Byte.TYPE.equals(propertyType) ? "getByte" : (Character.TYPE.equals(propertyType) ? "getChar" : (Short.TYPE.equals(propertyType) ? "getShort" : (Integer.TYPE.equals(propertyType) ? "getInt" : (Long.TYPE.equals(propertyType) ? "getLong" : (Float.TYPE.equals(propertyType) ? "getFloat" : (Double.TYPE.equals(propertyType) ? "getDouble" : "getObject")))))));
                propertyVar.init((JExpression)fieldAccessorField.invoke(methodName).arg(beanVar).arg((JExpression)builder.getWriteContextVar()).arg(beanVar));
            }
        } else if (property.getGetter() != null) {
            Method getter = property.getGetter();
            if (!JavaUtils.isPrivate(getter)) {
                propertyVar.init(JExpr._null());
                JTryBlock tryGetter = block._try();
                tryGetter.body().assign((JAssignmentTarget)propertyVar, (JExpression)beanVar.invoke(getter.getName()));
                JCatchBlock catchException = tryGetter._catch(this.context.toJClass(Exception.class));
                catchException.body().invoke((JExpression)builder.getReadContextVar(), "getterError").arg(beanVar).arg(property.getName()).arg(this.context.dotclass(property.getBean().getType())).arg(getter.getName()).arg((JExpression)catchException.param("e"));
            } else {
                JFieldVar propertyAccessorField = builder.getPrivatePropertyAccessor(property.getGetter(), property.getSetter(), property.getName());
                propertyVar.init((JExpression)propertyAccessorField.invoke("getObject").arg(beanVar).arg((JExpression)builder.getWriteContextVar()).arg(beanVar));
            }
        } else {
            throw new BuildException("Property does not have a getter " + property.getBean().getClass().getName() + "." + property.getName());
        }
        return propertyVar;
    }

    private void writeClassWriter(JAXBObjectBuilder builder, Bean bean, JBlock block, JExpression propertyVar) {
        JAXBObjectBuilder existingBuilder = this.builders.get(bean);
        if (existingBuilder == null) {
            throw new BuildException("Unknown bean " + bean);
        }
        builder.addDependency((JClass)existingBuilder.getJAXBObjectClass());
        String methodName = "write" + bean.getType().getSimpleName();
        if (builder != existingBuilder) {
            JStaticImports staticImports = JStaticImports.getStaticImports((JDefinedClass)builder.getJAXBObjectClass());
            staticImports.addStaticImport(existingBuilder.getJAXBObjectClass().fullName() + "." + methodName);
        }
        JInvocation invocation = JExpr.invoke((String)methodName).arg((JExpression)builder.getXSW()).arg(propertyVar).arg((JExpression)builder.getWriteContextVar());
        block.add((JStatement)invocation);
    }

    private List<Bean> getSubstitutionTypes(Class<?> c) {
        ArrayList<Bean> beans = new ArrayList<Bean>();
        for (Bean bean : this.model.getBeans()) {
            if (!c.isAssignableFrom(bean.getType()) || bean.getSchemaTypeName() == null) continue;
            beans.add(bean);
        }
        Collections.sort(beans, new BeanComparator());
        return beans;
    }

    private <T extends JExpression> T writeAdapterConversion(JAXBObjectBuilder builder, JBlock block, Property property, T propertyVar) {
        if (property.getAdapterType() != null) {
            JVar adapterVar = builder.getAdapter(property.getAdapterType());
            JVar valueVar = block.decl((JType)this.context.toJClass(property.getComponentAdaptedType()), builder.getWriteVariableManager().createId(property.getName()), JExpr._null());
            JTryBlock tryBlock = block._try();
            tryBlock.body().assign((JAssignmentTarget)valueVar, (JExpression)adapterVar.invoke("marshal").arg(propertyVar));
            JCatchBlock catchException = tryBlock._catch(this.context.toJClass(Exception.class));
            JBlock catchBody = catchException.body();
            catchBody.invoke((JExpression)builder.getReadContextVar(), "xmlAdapterError").arg((JExpression)builder.getWriteObject()).arg(property.getName()).arg(this.context.dotclass(property.getAdapterType())).arg(this.context.dotclass(JavaUtils.toClass(property.getType()))).arg(this.context.dotclass(JavaUtils.toClass(property.getType()))).arg((JExpression)catchException.param("e"));
            propertyVar = valueVar;
        }
        return propertyVar;
    }

    private void writeSimpleTypeElement(JAXBObjectBuilder builder, JExpression object, Class type, JBlock block) {
        if (this.isBuiltinType(type)) {
            block.add((JStatement)builder.getXSW().invoke("writeCharacters").arg(this.toString(builder, object, type)));
        } else if (type.equals(byte[].class)) {
            block.add((JStatement)this.context.toJClass(BinaryUtils.class).staticInvoke("encodeBytes").arg((JExpression)builder.getXSW()).arg(object));
        } else if (type.equals(QName.class)) {
            block.add((JStatement)builder.getXSW().invoke("writeQName").arg(object));
        } else if (!type.equals(DataHandler.class) && !type.equals(Image.class)) {
            if (type.equals(Object.class)) {
                block.add((JStatement)builder.getXSW().invoke("writeDomElement").arg((JExpression)JExpr.cast((JType)this.context.toJClass(Element.class), (JExpression)object)).arg(JExpr.FALSE));
            } else {
                logger.info("(JAXB Writer) Cannot map simple type yet: " + type);
            }
        }
    }

    private void writeSimpleTypeAttribute(JAXBObjectBuilder builder, JBlock block, Property property, JExpression propertyVar) {
        JVar stringBuilder = null;
        JExpression itemVar = propertyVar;
        JBlock itemBlock = block;
        if (property.isCollection()) {
            JBlock newBody;
            Object itemType = !JavaUtils.toClass(property.getComponentType()).isPrimitive() ? this.context.getGenericType(property.getComponentType()) : this.context.toJType(JavaUtils.toClass(property.getComponentType()));
            String valueName = builder.getWriteVariableManager().createId(property.getName() + "Value");
            stringBuilder = block.decl((JType)this.context.toJClass(StringBuilder.class), valueName, (JExpression)JExpr._new((JClass)this.context.toJClass(StringBuilder.class)));
            String itemName = builder.getWriteVariableManager().createId(property.getName() + "Item");
            JForEach each = block.forEach((JType)itemType, itemName, propertyVar);
            itemBlock = newBody = each.body();
            itemVar = each.var();
            itemBlock._if(stringBuilder.invoke("length").ne(JExpr.lit((int)0)))._then().invoke((JExpression)stringBuilder, "append").arg(" ");
            propertyVar = stringBuilder.invoke("toString");
        }
        itemVar = this.writeAdapterConversion(builder, itemBlock, property, itemVar);
        Class type = property.getAdapterType() == null ? JavaUtils.toClass(property.getComponentType()) : property.getComponentAdaptedType();
        if (property.isIdref()) {
            Property idProperty = this.findReferencedIdProperty(property);
            itemVar = this.getValue(builder, itemVar, idProperty, property.getName() + JavaUtils.capitalize(idProperty.getName()), itemBlock);
            type = String.class;
            JConditional nullCond = itemBlock._if(itemVar.ne(JExpr._null()));
            itemBlock = nullCond._then();
        }
        if (this.isBuiltinType(type)) {
            itemVar = this.toString(builder, itemVar, type);
        } else if (type.equals(byte[].class)) {
            itemVar = this.context.toJClass(Base64.class).staticInvoke("encode").arg(itemVar);
        } else if (type.equals(QName.class)) {
            itemVar = builder.getXSW().invoke("getQNameAsString").arg(itemVar);
        } else if (!type.equals(DataHandler.class) && !type.equals(Image.class)) {
            logger.info("(JAXB Writer) Cannot map simple attribute type yet: " + type);
            return;
        }
        if (stringBuilder != null) {
            itemBlock.invoke(stringBuilder, "append").arg(itemVar);
        } else {
            propertyVar = itemVar;
        }
        QName name = property.getXmlName();
        JExpression prefix = name.getNamespaceURI().length() > 0 ? builder.getWriterPrefix(name.getNamespaceURI()) : JExpr.lit((String)"");
        block.add((JStatement)builder.getXSW().invoke("writeAttribute").arg(prefix).arg(JExpr.lit((String)name.getNamespaceURI())).arg(JExpr.lit((String)name.getLocalPart())).arg(propertyVar));
    }

    private Property findReferencedIdProperty(Property property) {
        Bean targetBean = this.model.getBean(JavaUtils.toClass(property.getComponentType()));
        if (targetBean == null) {
            throw new BuildException("Unknown bean " + JavaUtils.toClass(property.getType()));
        }
        Property idProperty = null;
        while (idProperty == null) {
            for (Property targetProperty : targetBean.getProperties()) {
                if (!targetProperty.isId()) continue;
                idProperty = targetProperty;
                break;
            }
            if (idProperty != null) continue;
            if (targetBean.getBaseClass() == null) {
                throw new BuildException("Property " + property + " is an IDREF, but property type " + JavaUtils.toClass(property.getType()).getName() + " does not have an ID property");
            }
            targetBean = targetBean.getBaseClass();
        }
        return idProperty;
    }

    private void writeSimpleTypeAttribute(JAXBObjectBuilder builder, JBlock block, JExpression qnameVar, Class type, JExpression value) {
        if (this.isBuiltinType(type)) {
            value = this.toString(builder, value, type);
        } else if (type.equals(byte[].class)) {
            value = this.context.toJClass(Base64.class).staticInvoke("encode").arg(value);
        } else if (type.equals(QName.class)) {
            value = builder.getXSW().invoke("getQNameAsString").arg(value);
        } else if (!type.equals(DataHandler.class) && !type.equals(Image.class)) {
            logger.info("(JAXB Writer) Cannot map simple attribute type yet: " + type);
            return;
        }
        block.add((JStatement)builder.getXSW().invoke("writeAttribute").arg(qnameVar).arg(value));
    }

    private String getMostPopularNS(Set<Property> properties) {
        ArrayList<QName> names = new ArrayList<QName>();
        for (Property property : properties) {
            if (property.getXmlName() != null) {
                names.add(property.getXmlName());
            }
            for (ElementMapping mapping : property.getElementMappings()) {
                if (mapping.getXmlName() == null) continue;
                names.add(mapping.getXmlName());
            }
        }
        String mostPopularNS = null;
        int mostPopularCount = 0;
        TreeMap<String, Integer> nsCount = new TreeMap<String, Integer>();
        for (QName name : names) {
            String namespace = name.getNamespaceURI();
            if (namespace.length() <= 0) continue;
            Integer count = (Integer)nsCount.get(namespace);
            count = count == null ? 0 : count + 1;
            nsCount.put(namespace, count);
            if (count <= mostPopularCount) continue;
            mostPopularNS = namespace;
            mostPopularCount = count;
        }
        return mostPopularNS;
    }

    private boolean isBuiltinType(Class type) {
        return type.equals(Boolean.TYPE) || type.equals(Byte.TYPE) || type.equals(Short.TYPE) || type.equals(Integer.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(String.class) || type.equals(Boolean.class) || type.equals(Byte.class) || type.equals(Short.class) || type.equals(Integer.class) || type.equals(Long.class) || type.equals(Float.class) || type.equals(Double.class) || type.equals(XMLGregorianCalendar.class) || type.equals(Duration.class) || type.equals(BigDecimal.class) || type.equals(BigInteger.class) || type.isEnum();
    }

    private JExpression toString(JAXBObjectBuilder builder, JExpression value, Class<?> type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return this.context.toJClass(Boolean.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Byte.TYPE)) {
                return this.context.toJClass(Byte.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Short.TYPE)) {
                return this.context.toJClass(Short.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Integer.TYPE)) {
                return this.context.toJClass(Integer.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Long.TYPE)) {
                return this.context.toJClass(Long.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Float.TYPE)) {
                return this.context.toJClass(Float.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Double.TYPE)) {
                return this.context.toJClass(Double.class).staticInvoke("toString").arg(value);
            }
        } else {
            if (type.equals(String.class)) {
                return value;
            }
            if (type.equals(Boolean.class)) {
                return this.context.toJClass(Boolean.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Byte.class)) {
                return this.context.toJClass(Byte.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Short.class)) {
                return this.context.toJClass(Short.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Integer.class)) {
                return this.context.toJClass(Integer.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Long.class)) {
                return this.context.toJClass(Long.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Float.class)) {
                return this.context.toJClass(Float.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(Double.class)) {
                return this.context.toJClass(Double.class).staticInvoke("toString").arg(value);
            }
            if (type.equals(XMLGregorianCalendar.class)) {
                return value.invoke("toXMLFormat");
            }
            if (type.equals(Duration.class)) {
                return value.invoke("toString");
            }
            if (type.equals(BigDecimal.class)) {
                return value.invoke("toString");
            }
            if (type.equals(BigInteger.class)) {
                return value.invoke("toString");
            }
            if (type.isEnum()) {
                JAXBEnumBuilder enumBuilder = this.enumBuilders.get(type);
                if (enumBuilder == null) {
                    throw new BuildException("Unknown enum type " + type);
                }
                return this.invokeEnumToString(builder, builder.getWriteObject(), JExpr._null(), enumBuilder, value);
            }
        }
        throw new UnsupportedOperationException("Invalid type " + type);
    }

    private JInvocation invokeEnumToString(JAXBObjectBuilder caller, JVar beanVar, JExpression parameterName, JAXBEnumBuilder enumBuilder, JExpression value) {
        caller.addDependency((JClass)enumBuilder.getJAXBEnumClass());
        String methodName = "toString" + enumBuilder.getType().getSimpleName();
        JStaticImports staticImports = JStaticImports.getStaticImports((JDefinedClass)caller.getJAXBObjectClass());
        staticImports.addStaticImport(enumBuilder.getJAXBEnumClass().fullName() + "." + methodName);
        JInvocation invocation = JExpr.invoke((String)methodName).arg((JExpression)beanVar).arg(parameterName).arg((JExpression)caller.getWriteContextVar()).arg(value);
        return invocation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassComparator
    implements Comparator<Class> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class left, Class right) {
            if (left.equals(right)) {
                return 0;
            }
            if (left.isAssignableFrom(right)) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanComparator
    implements Comparator<Bean> {
        private BeanComparator() {
        }

        @Override
        public int compare(Bean left, Bean right) {
            if (left.equals(right)) {
                return 0;
            }
            if (left.getType().isAssignableFrom(right.getType())) {
                return 1;
            }
            return -1;
        }
    }
}

