/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.jaxb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEventStreamReader
implements XMLStreamReader {
    private final XMLEventReader reader;
    private XMLEvent current;
    private List<Attribute> attributes;
    private List<Namespace> namespaces;
    private LinkedList<NamespaceContext> namespaceContextStack = new LinkedList();
    private static String[] EVENT_NAMES = new String[]{"START_ELEMENT", "END_ELEMENT", "PROCESSING_INSTRUCTION", "CHARACTERS", "COMMENT", "SPACE", "START_DOCUMENT", "END_DOCUMENT", "ENTITY_REFERENCE", "ATTRIBUTE", "DTD", "CDATA", "NAMESPACE", "NOTATION_DECLARATION", "ENTITY_DECLARATION"};

    public XMLEventStreamReader(XMLEventReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.current != null && this.current.isEndElement()) {
            this.namespaceContextStack.removeFirst();
        }
        this.current = this.reader.nextEvent();
        this.attributes = null;
        this.namespaces = null;
        if (this.current.isStartElement()) {
            this.namespaceContextStack.addFirst(this.current.asStartElement().getNamespaceContext());
        }
        return this.current.getEventType();
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.current.isEndElement()) {
            this.namespaceContextStack.removeFirst();
        }
        this.current = this.reader.nextTag();
        this.attributes = null;
        this.namespaces = null;
        if (this.current.isStartElement()) {
            this.namespaceContextStack.addFirst(this.current.asStartElement().getNamespaceContext());
        }
        return this.current.getEventType();
    }

    @Override
    public int getEventType() {
        if (this.current == null) {
            return -1;
        }
        return this.current.getEventType();
    }

    @Override
    public Location getLocation() {
        return this.current.getLocation();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.reader.getProperty(name);
    }

    @Override
    public void close() throws XMLStreamException {
        this.reader.close();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (type != this.getEventType()) {
            throw new XMLStreamException("Expected event type " + type + ", but was " + this.getEventType(), this.getLocation());
        }
        if (namespaceURI != null && !namespaceURI.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Expected namespaceURI " + namespaceURI + ", but was " + this.getNamespaceURI(), this.getLocation());
        }
        if (localName != null && !localName.equals(this.getLocalName())) {
            throw new XMLStreamException("Expected localName " + localName + ", but was " + this.getLocalName(), this.getLocation());
        }
    }

    @Override
    public QName getName() {
        this.requiredEventType(1, 2);
        if (this.current instanceof StartElement) {
            return this.current.asStartElement().getName();
        }
        return this.current.asEndElement().getName();
    }

    @Override
    public String getPrefix() {
        return this.getName().getPrefix();
    }

    @Override
    public String getNamespaceURI() {
        return this.getName().getNamespaceURI();
    }

    @Override
    public String getLocalName() {
        return this.getName().getLocalPart();
    }

    @Override
    public boolean isEndElement() {
        return this.current.isEndElement();
    }

    @Override
    public boolean isStartElement() {
        return this.current.isStartElement();
    }

    @Override
    public boolean hasName() {
        int event = this.getEventType();
        return event == 1 || event == 2;
    }

    public List<Attribute> getAttributes() {
        this.requiredEventType(1);
        if (this.attributes == null) {
            this.attributes = new ArrayList<Attribute>();
            Iterator<Attribute> iter = this.current.asStartElement().getAttributes();
            while (iter.hasNext()) {
                this.attributes.add(iter.next());
            }
        }
        return this.attributes;
    }

    @Override
    public int getAttributeCount() {
        return this.getAttributes().size();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.getAttributes().get(index).getName();
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.getAttributeName(index).getPrefix();
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.getAttributeName(index).getNamespaceURI();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.getAttributeName(index).getLocalPart();
    }

    @Override
    public String getAttributeType(int index) {
        return this.getAttributes().get(index).getName().getPrefix();
    }

    @Override
    public String getAttributeValue(int index) {
        return this.getAttributes().get(index).getValue();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.getAttributes().get(index).isSpecified();
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        for (Attribute attribute : this.getAttributes()) {
            if (!attribute.getName().getNamespaceURI().equals(namespaceURI) || !attribute.getName().getLocalPart().equals(localName)) continue;
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public boolean hasText() {
        int event = this.getEventType();
        return event == 4 || event == 11 || event == 9 || event == 5 || event == 6;
    }

    @Override
    public String getText() {
        this.requiredEventType(4, 11, 9, 5, 6);
        if (this.current.isCharacters()) {
            return this.current.asCharacters().getData();
        }
        if (this.current.isEntityReference()) {
            return ((EntityReference)this.current).getDeclaration().getReplacementText();
        }
        if (this.current instanceof DTD) {
            return "";
        }
        if (this.current instanceof Comment) {
            return ((Comment)this.current).getText();
        }
        throw new IllegalStateException("Unexpected element type " + this.current);
    }

    @Override
    public char[] getTextCharacters() {
        this.requiredEventType(4, 12, 6);
        return this.getText().toCharArray();
    }

    @Override
    public int getTextStart() {
        this.requiredEventType(4, 12, 6);
        return 0;
    }

    @Override
    public int getTextLength() {
        this.requiredEventType(4, 12, 6);
        return this.getText().length();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int targetLength) throws XMLStreamException {
        this.requiredEventType(4, 12, 6);
        String source = this.getText();
        int length = Math.min(targetLength, source.length() - sourceStart);
        source.getChars(sourceStart, sourceStart + length, target, targetStart);
        return length;
    }

    @Override
    public boolean isCharacters() {
        return this.current.isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.current.isCharacters() && this.current.asCharacters().isIgnorableWhiteSpace();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        if (this.getEventType() != 1) {
            throw new XMLStreamException();
        }
        StringBuilder text = new StringBuilder();
        int eventType = this.next();
        while (eventType != 2) {
            if (eventType == 1) {
                throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
            }
            if (eventType == 8) {
                throw new XMLStreamException("unexpected end of document when reading element text content", this.getLocation());
            }
            if (eventType == 12 || eventType == 4 || eventType == 9 || eventType == 6) {
                text.append(this.getText());
            } else if (eventType != 5 && eventType != 3) {
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return text.toString();
    }

    @Override
    public String getCharacterEncodingScheme() {
        this.requiredEventType(7);
        return ((StartDocument)this.current).getCharacterEncodingScheme();
    }

    @Override
    public String getEncoding() {
        return null;
    }

    @Override
    public String getVersion() {
        this.requiredEventType(7);
        return ((StartDocument)this.current).getVersion();
    }

    @Override
    public boolean isStandalone() {
        this.requiredEventType(7);
        return ((StartDocument)this.current).isStandalone();
    }

    @Override
    public boolean standaloneSet() {
        this.requiredEventType(7);
        return ((StartDocument)this.current).standaloneSet();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContextStack.getFirst();
    }

    public List<Namespace> getNamespaces() {
        this.requiredEventType(1, 2);
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<Namespace>();
            Iterator<Namespace> iter = this.current.isStartElement() ? this.current.asStartElement().getNamespaces() : this.current.asEndElement().getNamespaces();
            while (iter.hasNext()) {
                this.attributes.add(iter.next());
            }
        }
        return this.namespaces;
    }

    @Override
    public int getNamespaceCount() {
        return this.getNamespaces().size();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.getNamespaces().get(index).getPrefix();
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.getNamespaces().get(index).getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.getNamespaceContext().getNamespaceURI(prefix);
    }

    @Override
    public String getPIData() {
        this.requiredEventType(3);
        ProcessingInstruction pi = (ProcessingInstruction)this.current;
        return pi.getData();
    }

    @Override
    public String getPITarget() {
        this.requiredEventType(3);
        ProcessingInstruction pi = (ProcessingInstruction)this.current;
        return pi.getTarget();
    }

    private void requiredEventType(int ... eventTypes) {
        int event = this.getEventType();
        for (int eventType : eventTypes) {
            if (eventType != event) continue;
            return;
        }
        throw new IllegalStateException("Expected event type " + this.getEventNames("or", eventTypes) + ", but was " + EVENT_NAMES[event]);
    }

    private String getEventNames(String junction, int ... eventTypes) {
        if (eventTypes.length == 0) {
            return "";
        }
        if (eventTypes.length == 1) {
            return EVENT_NAMES[eventTypes[0]];
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < eventTypes.length; ++i) {
            int event = eventTypes[i];
            if (i == 0) {
                buffer.append(EVENT_NAMES[event]);
                continue;
            }
            if (i == eventTypes.length - 1) {
                buffer.append(" ").append(junction).append(" ").append(EVENT_NAMES[event]);
                continue;
            }
            buffer.append(", ").append(EVENT_NAMES[event]);
        }
        return buffer.toString();
    }
}

