/*
 * Decompiled with CFR 0.152.
 */
package com.envoisolutions.sxc.builder.impl;

import com.envoisolutions.sxc.Context;
import com.envoisolutions.sxc.Reader;
import com.envoisolutions.sxc.Writer;
import com.envoisolutions.sxc.builder.BuildException;
import java.lang.reflect.Constructor;

public class CompiledContext
extends Context {
    private Constructor<?> readerConstructor;
    private Constructor<?> writerConstructor;

    public CompiledContext(ClassLoader cl, String readerClsName, String writerClsName) {
        try {
            if (readerClsName != null) {
                Class<?> readerCls = cl.loadClass(readerClsName);
                this.readerConstructor = readerCls.getConstructor(Context.class);
            }
            if (writerClsName != null) {
                Class<?> writerCls = cl.loadClass(writerClsName);
                this.writerConstructor = writerCls.getConstructor(Context.class);
            }
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public Reader createReader() {
        try {
            return (Reader)this.readerConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public Writer createWriter() {
        try {
            return (Writer)this.writerConstructor.newInstance(this);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }
}

