/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.application.adapter.inbound;

import com.eorion.bo.enhancement.application.domain.dto.ApplicationStructureMapper;
import com.eorion.bo.enhancement.application.domain.dto.inbound.ApplicationSaveDTO;
import com.eorion.bo.enhancement.application.domain.dto.inbound.ApplicationUpdateDTO;
import com.eorion.bo.enhancement.application.domain.dto.inbound.QueryApplicationDTO;
import com.eorion.bo.enhancement.application.domain.dto.outbound.CountDTO;
import com.eorion.bo.enhancement.application.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.application.domain.entity.Application;
import com.eorion.bo.enhancement.application.domain.exception.DataNotExistException;
import com.eorion.bo.enhancement.application.domain.exception.InsertFailedException;
import com.eorion.bo.enhancement.application.domain.exception.UpdateFailedException;
import com.eorion.bo.enhancement.application.service.ApplicationService;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enhancement/application"})
public class ApplicationController {
    private final ApplicationService service;
    private final ApplicationStructureMapper structureMapper;

    public ApplicationController(ApplicationService service, ApplicationStructureMapper structureMapper) {
        this.service = service;
        this.structureMapper = structureMapper;
    }

    @PostMapping
    public IdDTO<?> saveApplication(@Validated @RequestBody ApplicationSaveDTO saveDto) throws InsertFailedException {
        return this.service.save(this.structureMapper.saveDtoToEntity(saveDto));
    }

    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateApplication(@PathVariable(value="id") Integer id, @RequestBody ApplicationUpdateDTO updateDto) throws UpdateFailedException {
        this.service.updateApplication(id, this.structureMapper.updateDtoToEntity(updateDto));
    }

    @GetMapping(value={"/{id}"})
    public Application getDetail(@PathVariable(value="id") Integer id) throws DataNotExistException {
        return this.service.getDetailById(id);
    }

    @PostMapping(value={"/list"})
    public List<Application> getApplicationList(@RequestBody(required=false) QueryApplicationDTO query, @RequestParam(value="firstResult", defaultValue="0") Integer firstResult, @RequestParam(value="maxResults", defaultValue="2147483647") Integer maxResults) {
        return this.service.getApplicationList(query, firstResult, maxResults);
    }

    @PostMapping(value={"/count"})
    public CountDTO getApplicationCount(@RequestBody(required=false) QueryApplicationDTO query) {
        return this.service.getApplicationCount(query);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteById(@PathVariable(value="id") Integer id) throws UpdateFailedException {
        this.service.deleteById(id);
    }

    @PostMapping(value={"/{id}/publish"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void applicationPublish(@PathVariable(value="id") Long id) throws DataNotExistException, UpdateFailedException {
        this.service.applicationPublish(id);
    }

    @PostMapping(value={"/{id}/off"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void applicationTakeDown(@PathVariable(value="id") Long id) throws DataNotExistException, UpdateFailedException {
        this.service.applicationTakeDown(id);
    }
}

