/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.application.domain.handler;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSerializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JacksonSerializer.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static String toJSONString(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            log.error("Object to json stirng error", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> type) {
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                return (T)mapper.readValue(json, type);
            }
            catch (Exception e) {
                log.error("Json parse to object error {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.registerModule((Module)new ParameterNamesModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
    }
}

