/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.application.service;

import com.eorion.bo.enhancement.application.adapter.outbound.ApplicationRepository;
import com.eorion.bo.enhancement.application.domain.dto.inbound.QueryApplicationDTO;
import com.eorion.bo.enhancement.application.domain.dto.outbound.CountDTO;
import com.eorion.bo.enhancement.application.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.application.domain.entity.Application;
import com.eorion.bo.enhancement.application.domain.enums.ApplicationStatus;
import com.eorion.bo.enhancement.application.domain.exception.DataNotExistException;
import com.eorion.bo.enhancement.application.domain.exception.InsertFailedException;
import com.eorion.bo.enhancement.application.domain.exception.UpdateFailedException;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.engine.IdentityService;
import org.springframework.stereotype.Service;

@Service
public class ApplicationService {
    private final ApplicationRepository repository;
    private final IdentityService identityService;

    public ApplicationService(ApplicationRepository repository, IdentityService identityService) {
        this.repository = repository;
        this.identityService = identityService;
    }

    public IdDTO<Integer> save(Application application) throws InsertFailedException {
        if (!this.repository.save(application)) {
            throw new InsertFailedException();
        }
        return new IdDTO<Integer>(application.getId());
    }

    public void updateApplication(Integer id, Application application) throws UpdateFailedException {
        String userId = this.identityService.getCurrentAuthentication().getUserId();
        Application dbApplication = (Application)this.repository.getById(id);
        if (Objects.nonNull(dbApplication)) {
            application.setId(id);
            if (!this.repository.updateById(application)) {
                throw new UpdateFailedException();
            }
        } else {
            throw new UpdateFailedException("\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u662f\u8d44\u6e90\u662f\u5426\u5b58\u5728\u6216\u662f\u5426\u5177\u6709\u66f4\u65b0\u8d44\u6e90\u7684\u6743\u9650\uff01");
        }
    }

    public void deleteById(Integer id) throws UpdateFailedException {
        String userId = this.identityService.getCurrentAuthentication().getUserId();
        Application application = (Application)this.repository.getById(id);
        if (Objects.nonNull(application) && application.getOwner().equals(userId)) {
            if (!this.repository.removeById(id)) {
                throw new UpdateFailedException();
            }
        } else {
            throw new UpdateFailedException("\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u8d44\u6e90\u662f\u5426\u5b58\u5728\u6216\u662f\u5426\u5177\u6709\u5220\u9664\u8d44\u6e90\u7684\u6743\u9650\uff01");
        }
    }

    public Application getDetailById(Integer id) throws DataNotExistException {
        Application application = (Application)this.repository.getById(id);
        if (Objects.isNull(application)) {
            throw new DataNotExistException();
        }
        return application;
    }

    public List<Application> getApplicationList(QueryApplicationDTO query, Integer firstResult, Integer maxResults) {
        return this.repository.selectApplicationPageList(query, firstResult, maxResults);
    }

    public void applicationPublish(Long id) throws DataNotExistException, UpdateFailedException {
        Application dbApplication = (Application)this.repository.getById(id);
        if (Objects.isNull(dbApplication)) {
            throw new DataNotExistException("\u5bf9\u5e94ID\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        dbApplication.setStatus(ApplicationStatus.PUBLISH);
        if (!this.repository.updateById(dbApplication)) {
            throw new UpdateFailedException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    public void applicationTakeDown(Long id) throws DataNotExistException, UpdateFailedException {
        Application dbApplication = (Application)this.repository.getById(id);
        if (Objects.isNull(dbApplication)) {
            throw new DataNotExistException("\u5bf9\u5e94ID\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        dbApplication.setStatus(ApplicationStatus.DRAFT);
        if (!this.repository.updateById(dbApplication)) {
            throw new UpdateFailedException("\u66f4\u65b0\u5931\u8d25");
        }
    }

    public CountDTO getApplicationCount(QueryApplicationDTO query) {
        return new CountDTO(this.repository.selectApplicationCount(query));
    }
}

