-- liquibase formatted sql

-- changeset eorion:1 dbms:oracle
create table ENHANCEMENT_APPLICATION
(
    ID              NUMBER(10,0)    NOT NULL,
    NAME_TXT        NVARCHAR2(255)  NOT NULL,
    ICON_URL        NVARCHAR2(2000),
    COE_CODE_TXT    NVARCHAR2(128),
    USER_GROUP_TXT  NVARCHAR2(128),
    EDIT_GROUP_TXT  NVARCHAR2(128),
    TAGS_TXT        NVARCHAR2(128),
    OWNER_TXT       NVARCHAR2(64),
    TENANT_TXT      NVARCHAR2(64),
    TYPE_TXT        NVARCHAR2(128),
    CATEGORY_TXT    NVARCHAR2(255),
    CONFIG_TXT      NCLOB,
    KEY_TXT         NVARCHAR2(128),
    STATUS_FG       CHAR(1)     DEFAULT '0',
    TARGET_TXT      NVARCHAR2(255)  DEFAULT 'local',
    TARGET_APPLICATION_ID NVARCHAR2(255),
    ACCESS_USERS_TXT NVARCHAR2(255),
    DESCRIPTION_TXT NCLOB,
    VERSION_TAG_TXT NVARCHAR2(64),
    CREATED_TS      NUMBER(13,0),
    UPDATED_TS      NUMBER(13,0),
    CREATE_BY_TXT   NVARCHAR2(20),
    UPDATED_BY_TXT  NVARCHAR2(20),
    DELETE_FG       NUMBER(1,0)     DEFAULT 0,
    PRIMARY KEY (ID)
);

-- changeset eorion:2 dbms:oracle
CREATE SEQUENCE ENHANCEMENT_APPLICATION_SEQ
    START WITH 1
    INCREMENT BY 1
    NOCACHE
NOCYCLE;

-- changeset eorion:3 dbms:oracle
CREATE OR REPLACE TRIGGER ENHANCEMENT_APPLICATION_ID_INSERT
BEFORE INSERT ON ENHANCEMENT_APPLICATION
FOR EACH ROW
BEGIN
  :NEW.ID := ENHANCEMENT_APPLICATION_SEQ.NEXTVAL;
END;
/