/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.delegation.adapter.inbound;

import com.eorion.bo.enhancement.delegation.domain.commom.PageInfo;
import com.eorion.bo.enhancement.delegation.domain.dto.inbound.DelegationManagementSaveDTO;
import com.eorion.bo.enhancement.delegation.domain.dto.inbound.DelegationManagementUpdateDTO;
import com.eorion.bo.enhancement.delegation.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.delegation.domain.entity.Delegation;
import com.eorion.bo.enhancement.delegation.domain.exception.RequestParamException;
import com.eorion.bo.enhancement.delegation.domain.exception.UpdateFailedException;
import com.eorion.bo.enhancement.delegation.service.DelegationManagementService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enhancement/delegation"})
public class DelegationManagementController {
    private final DelegationManagementService delegationManagementService;

    @GetMapping(value={"/{id}"})
    public Delegation getDelegationManagement(@PathVariable Long id) {
        return this.delegationManagementService.selectById(id);
    }

    @PostMapping
    public IdDTO<?> createDelegationManagement(@Valid @RequestBody DelegationManagementSaveDTO saveDTO) throws RequestParamException {
        return this.delegationManagementService.save(saveDTO);
    }

    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDelegationManagement(@PathVariable Long id, @RequestBody DelegationManagementUpdateDTO updateDTO) throws UpdateFailedException {
        this.delegationManagementService.updateById(id, updateDTO);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteDelegationManagement(@PathVariable Long id) throws UpdateFailedException {
        this.delegationManagementService.deleteById(id);
    }

    @GetMapping(value={""})
    public PageInfo<Delegation> getMyDelegationManagements(@RequestParam(value="delegateNameLike", required=false) String delegateNameLike, @RequestParam(value="ownerUserId") String ownerUserId, @RequestParam(value="tenant") String tenant, @RequestParam(value="delegateToUserNameLike", required=false) String delegateToUserNameLike, @RequestParam(value="startDateTimeAfter", required=false) Long startDateTimeAfter, @RequestParam(value="startDateTimeBefore", required=false) Long startDateTimeBefore, @RequestParam(value="endDateTimeAfter", required=false) Long endDateTimeAfter, @RequestParam(value="endDateTimeBefore", required=false) Long endDateTimeBefore, @RequestParam(value="status", required=false) String status, @RequestParam(value="groupsIn", required=false) String groupsIn, @RequestParam(value="orderBy", required=false) String orderBy, @RequestParam(value="sort", required=false, defaultValue="asc") String sort, @RequestParam(value="firstResult", required=false, defaultValue="0") Integer firstResult, @RequestParam(value="maxResults", required=false, defaultValue="2147483647") Integer maxResults) {
        return this.delegationManagementService.getMyDelegationManagements(delegateNameLike, ownerUserId, tenant, delegateToUserNameLike, startDateTimeAfter, startDateTimeBefore, endDateTimeBefore, endDateTimeAfter, status, groupsIn, orderBy, sort, firstResult, maxResults);
    }

    @GetMapping(value={"/granted"})
    public PageInfo<Delegation> getGrantedToMeDelegationManagements(@RequestParam(value="delegateNameLike", required=false) String delegateNameLike, @RequestParam(value="tenant") String tenant, @RequestParam(value="delegateToUserId") String delegateToUserId, @RequestParam(value="startDateTimeAfter", required=false) Long startDateTimeAfter, @RequestParam(value="startDateTimeBefore", required=false) Long startDateTimeBefore, @RequestParam(value="endDateTimeAfter", required=false) Long endDateTimeAfter, @RequestParam(value="endDateTimeBefore", required=false) Long endDateTimeBefore, @RequestParam(value="status", required=false) String status, @RequestParam(value="orderBy", required=false) String orderBy, @RequestParam(value="sort", required=false, defaultValue="asc") String sort, @RequestParam(value="firstResult", required=false, defaultValue="0") Integer firstResult, @RequestParam(value="maxResults", required=false, defaultValue="2147483647") Integer maxResults) {
        return this.delegationManagementService.getGrantedToMeDelegationManagements(delegateNameLike, tenant, delegateToUserId, startDateTimeBefore, startDateTimeAfter, endDateTimeBefore, endDateTimeAfter, status, orderBy, sort, firstResult, maxResults);
    }

    @Generated
    public DelegationManagementController(DelegationManagementService delegationManagementService) {
        this.delegationManagementService = delegationManagementService;
    }
}

