/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.delegation.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.eorion.bo.enhancement.delegation.adapter.outbound.DelegationManagementRepository;
import com.eorion.bo.enhancement.delegation.domain.DelegationManagementStructureMapper;
import com.eorion.bo.enhancement.delegation.domain.commom.PageInfo;
import com.eorion.bo.enhancement.delegation.domain.dto.inbound.DelegationManagementSaveDTO;
import com.eorion.bo.enhancement.delegation.domain.dto.inbound.DelegationManagementUpdateDTO;
import com.eorion.bo.enhancement.delegation.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.delegation.domain.entity.Delegation;
import com.eorion.bo.enhancement.delegation.domain.exception.RequestParamException;
import com.eorion.bo.enhancement.delegation.domain.exception.UpdateFailedException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.engine.IdentityService;
import org.springframework.stereotype.Service;

@Service
public class DelegationManagementService {
    private final DelegationManagementRepository repository;
    private final IdentityService identityService;
    private final DelegationManagementStructureMapper structureMapper;

    public Delegation selectById(Long id) {
        return (Delegation)this.repository.getById(id);
    }

    public IdDTO<Long> save(DelegationManagementSaveDTO saveDTO) throws RequestParamException {
        if (Objects.nonNull(saveDTO) && saveDTO.getStartDateTime() > saveDTO.getEndDateTime()) {
            throw new RequestParamException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        Delegation management = this.structureMapper.saveDtoToEntity(saveDTO);
        this.repository.save(management);
        return new IdDTO<Long>(management.getId());
    }

    public void updateById(Long id, DelegationManagementUpdateDTO updateDTO) throws UpdateFailedException {
        String userId = this.identityService.getCurrentAuthentication().getUserId();
        assert (userId != null);
        Delegation db = (Delegation)this.repository.getById(id);
        if (Objects.nonNull(db) && userId.equals(db.getCreatedBy())) {
            Delegation management = this.structureMapper.updateDtoToEntity(updateDTO);
            management.setId(id);
            try {
                this.repository.updateById(management);
            }
            catch (RuntimeException e) {
                throw new UpdateFailedException(e.getMessage());
            }
        } else {
            throw new UpdateFailedException("\u8bf7\u68c0\u67e5\u5f53\u524d\u7684\u8d44\u6e90\u662f\u5426\u5b58\u5728\u6216\u8005\u5f53\u524d\u767b\u9646\u7528\u6237\u662f\u5426\u662f\u8d44\u6e90\u521b\u5efa\u8005");
        }
    }

    public void deleteById(Long id) throws UpdateFailedException {
        String userId = this.identityService.getCurrentAuthentication().getUserId();
        assert (userId != null);
        Delegation db = (Delegation)this.repository.getById(id);
        if (Objects.nonNull(db) && userId.equals(db.getCreatedBy())) {
            try {
                this.repository.removeById(id);
            }
            catch (RuntimeException e) {
                throw new UpdateFailedException(e.getMessage());
            }
        } else {
            throw new UpdateFailedException("\u8bf7\u68c0\u67e5\u5f53\u524d\u7684\u8d44\u6e90\u662f\u5426\u5b58\u5728\u6216\u8005\u5f53\u524d\u767b\u9646\u7528\u6237\u662f\u5426\u662f\u8d44\u6e90\u521b\u5efa\u8005");
        }
    }

    public PageInfo<Delegation> getMyDelegationManagements(String delegateNameLike, String ownerUserId, String tenant, String delegateToUserNameLike, Long startDateTimeAfter, Long startDateTimeBefore, Long endDateTimeBefore, Long endDateTimeAfter, String status, String groupsIn, String orderBy, String sort, Integer firstResult, Integer maxResults) {
        Page page = new Page((long)firstResult.intValue(), (long)maxResults.intValue());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)ownerUserId), Delegation::getOwnerUserId, (Object)ownerUserId)).eq(StringUtils.isNotEmpty((CharSequence)tenant), Delegation::getTenant, (Object)tenant)).like(StringUtils.isNotEmpty((CharSequence)delegateNameLike), Delegation::getDelegateName, (Object)delegateNameLike)).like(StringUtils.isNotEmpty((CharSequence)delegateToUserNameLike), Delegation::getDelegateToUserName, (Object)delegateToUserNameLike)).le(startDateTimeBefore != null, Delegation::getStartDateTime, (Object)startDateTimeBefore)).ge(startDateTimeAfter != null, Delegation::getStartDateTime, (Object)startDateTimeAfter)).le(endDateTimeBefore != null, Delegation::getEndDateTime, (Object)endDateTimeBefore)).ge(endDateTimeAfter != null, Delegation::getEndDateTime, (Object)endDateTimeAfter);
        if (StringUtils.isNotEmpty((CharSequence)groupsIn)) {
            List<String> collect = Arrays.stream(groupsIn.split(",")).map(String::trim).toList();
            StringBuilder sql = new StringBuilder("EXISTS (SELECT 1 FROM regexp_split_to_table(USER_GROUPS, ',') AS a WHERE a IN (");
            for (int i2 = 0; i2 < collect.size(); ++i2) {
                sql.append("'").append(collect.get(i2)).append("'");
                if (i2 == collect.size() - 1) continue;
                sql.append(",");
            }
            sql.append("))");
            queryWrapper.and(i -> i.apply(sql.toString(), new Object[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            long l = System.currentTimeMillis();
            if ("1".equals(status)) {
                queryWrapper.ge(Delegation::getEndDateTime, (Object)l);
            } else if ("0".equals(status)) {
                queryWrapper.le(Delegation::getEndDateTime, (Object)l);
            }
        }
        if ("startDateTime".equals(orderBy) && StringUtils.isNotEmpty((CharSequence)sort)) {
            queryWrapper.last("order by START_DATE_TS " + sort);
        }
        Page result = (Page)this.repository.page((IPage)page, (Wrapper)queryWrapper);
        return new PageInfo<Delegation>(result.getTotal(), result.getRecords());
    }

    public PageInfo<Delegation> getGrantedToMeDelegationManagements(String delegateNameLike, String tenant, String delegateToUserId, Long startDateTimeBefore, Long startDateTimeAfter, Long endDateTimeBefore, Long endDateTimeAfter, String status, String orderBy, String sort, Integer firstResult, Integer maxResults) {
        Page page = new Page((long)firstResult.intValue(), (long)maxResults.intValue());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(StringUtils.isNotEmpty((CharSequence)delegateToUserId), Delegation::getDelegateToUserId, (Object)delegateToUserId)).eq(StringUtils.isNotEmpty((CharSequence)tenant), Delegation::getTenant, (Object)tenant)).like(StringUtils.isNotEmpty((CharSequence)delegateNameLike), Delegation::getDelegateName, (Object)delegateNameLike)).le(startDateTimeBefore != null, Delegation::getStartDateTime, (Object)startDateTimeBefore)).ge(startDateTimeAfter != null, Delegation::getStartDateTime, (Object)startDateTimeAfter)).le(endDateTimeBefore != null, Delegation::getEndDateTime, (Object)endDateTimeBefore)).ge(endDateTimeAfter != null, Delegation::getEndDateTime, (Object)endDateTimeAfter);
        if (StringUtils.isNotEmpty((CharSequence)status)) {
            long l = System.currentTimeMillis();
            if ("1".equals(status)) {
                queryWrapper.ge(Delegation::getEndDateTime, (Object)l);
            } else if ("0".equals(status)) {
                queryWrapper.le(Delegation::getEndDateTime, (Object)l);
            }
        }
        if ("startDateTime".equals(orderBy) && StringUtils.isNotEmpty((CharSequence)sort)) {
            queryWrapper.last("order by START_DATE_TS " + sort);
        }
        Page result = (Page)this.repository.page((IPage)page, (Wrapper)queryWrapper);
        return new PageInfo<Delegation>(result.getTotal(), result.getRecords());
    }

    @Generated
    public DelegationManagementService(DelegationManagementRepository repository, IdentityService identityService, DelegationManagementStructureMapper structureMapper) {
        this.repository = repository;
        this.identityService = identityService;
        this.structureMapper = structureMapper;
    }
}

