-- liquibase formatted sql

-- changeset eorion:1 dbms:oracle
CREATE TABLE ENHANCEMENT_DELEGATION
(
    ID                    NUMBER(10)        NOT NULL,
    DELEGATE_NAME         NVARCHAR2(255)    NOT NULL,
    OWNER_USER_ID         NVARCHAR2(64)     NOT NULL,
    OWNER_USER_NAME       NVARCHAR2(255)    NOT NULL,
    DELEGATE_TO_USER_ID   NVARCHAR2(64)     NOT NULL,
    DELEGATE_TO_USER_NAME NVARCHAR2(255)    NOT NULL,
    START_DATE_TS         NUMBER(13,0)      NOT NULL,
    END_DATE_TS           NUMBER(13,0)      NOT NULL,
    USER_GROUPS           NVARCHAR2(255),
    TENANT_TXT            NVARCHAR2(64),
    CREATED_TS            NUMBER(13,0),
    UPDATED_TS            NUMBER(13,0),
    CREATE_BY_TXT         NVARCHAR2(20),
    UPDATED_BY_TXT        NVARCHAR2(20),
    DELETE_FG             NUMBER(1,0)       DEFAULT 0,
    PRIMARY KEY (ID)
);

-- changeset eorion:2 dbms:oracle
CREATE SEQUENCE ENHANCEMENT_DELEGATION_SEQ
    START WITH 1
    INCREMENT BY 1
    NOCACHE
NOCYCLE;

-- changeset eorion:3 dbms:oracle
CREATE OR REPLACE TRIGGER ENHANCEMENT_DELEGATION_ID_INSERT
BEFORE INSERT ON ENHANCEMENT_DELEGATION
FOR EACH ROW
BEGIN
  :NEW.ID := ENHANCEMENT_DELEGATION_SEQ.NEXTVAL;
END;
/