/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.emailincidentnotification.handler;

import com.eorion.bo.enhancement.emailincidentnotification.config.EmailIncidentNotificationConfigurationProperty;
import com.eorion.bo.enhancement.emailincidentnotification.domain.IncidentInformation;
import com.eorion.bo.enhancement.emailincidentnotification.domain.RecipientInfo;
import com.eorion.bo.enhancement.emailincidentnotification.handler.IncidentTimerTask;
import com.eorion.bo.enhancement.emailincidentnotification.util.DefaultTimeProvider;
import com.eorion.bo.enhancement.emailincidentnotification.util.ITimeProvider;
import com.sun.mail.smtp.SMTPTransport;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.camunda.bpm.engine.impl.incident.DefaultIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.IncidentEntity;
import org.camunda.bpm.engine.runtime.Incident;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BufferingIncidentHandler
extends DefaultIncidentHandler {
    public static final String TIME_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss z";
    public static final String INCIDENT_NOTIFICATION_RECEIVER = "incidentNotificationReceiver";
    public static final String INCIDENT_NOTIFICATION_CC = "incidentNotificationCc";
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferingIncidentHandler.class);
    private final EmailIncidentNotificationConfigurationProperty config;
    private final ITimeProvider timeProvider;
    private List<IncidentInformation> incidentInfos = new CopyOnWriteArrayList<IncidentInformation>();

    public BufferingIncidentHandler(ITimeProvider timeProvider, String type, EmailIncidentNotificationConfigurationProperty config) {
        super(type);
        this.timeProvider = timeProvider;
        this.config = config;
    }

    public BufferingIncidentHandler(String type, EmailIncidentNotificationConfigurationProperty config) {
        this(new DefaultTimeProvider(), type, config);
    }

    public IncidentEntity superHandleIncident(IncidentContext context, String message) {
        return (IncidentEntity)super.handleIncident(context, message);
    }

    public synchronized Incident handleIncident(IncidentContext ctx, String message) {
        LOGGER.debug("An incident occurs");
        IncidentEntity incEnt = this.superHandleIncident(ctx, message);
        this.incidentInfos.add(this.createIncidentInfo(incEnt));
        return incEnt;
    }

    public IncidentInformation createIncidentInfo(IncidentEntity incEnt) {
        ExecutionEntity execution = incEnt.getExecution();
        String emailReceiver = execution == null ? null : (String)execution.getVariable(INCIDENT_NOTIFICATION_RECEIVER);
        String emailCc = execution == null ? null : (String)execution.getVariable(INCIDENT_NOTIFICATION_CC);
        return new IncidentInformation(incEnt.getIncidentType(), incEnt.getActivityId(), this.clean(incEnt.getIncidentMessage()), incEnt.getProcessInstanceId(), new SimpleDateFormat(TIME_FORMAT_STRING).format(this.timeProvider.now()), incEnt.getProcessDefinitionId(), incEnt.getProcessDefinition() == null ? null : incEnt.getProcessDefinition().getName(), new RecipientInfo(emailReceiver, emailCc));
    }

    private String clean(String input) {
        if (input == null) {
            return "";
        }
        String result = input.replaceAll("\\{", "");
        result = result.replaceAll("\\}", "");
        result = result.replaceAll("\\$", "");
        return result;
    }

    public void startTimer() {
        LOGGER.debug("Starting timer for Incident");
        this.createTimer().scheduleAtFixedRate((TimerTask)this.createTimerTask(), this.config.intervalMs(), (long)this.config.intervalMs());
    }

    public IncidentTimerTask createTimerTask() {
        return new IncidentTimerTask(this);
    }

    public Timer createTimer() {
        return new Timer();
    }

    public synchronized void sendEmailIfNecessary() {
        if (!this.incidentInfos.isEmpty() && this.sendEmailsToRecipients()) {
            this.incidentInfos.clear();
        }
    }

    public synchronized boolean sendEmailsToRecipients() {
        RecipientInfo recipientInfo;
        boolean success = true;
        HashMap<RecipientInfo, List> incidentInfosByRecipientInfo = new HashMap<RecipientInfo, List>();
        for (IncidentInformation incidentInformation : this.incidentInfos) {
            recipientInfo = incidentInformation.recipientInfo();
            List targetList = incidentInfosByRecipientInfo.computeIfAbsent(recipientInfo, k -> new ArrayList());
            targetList.add(incidentInformation);
        }
        for (Map.Entry entry : incidentInfosByRecipientInfo.entrySet()) {
            List incidents;
            String messageText;
            recipientInfo = (RecipientInfo)entry.getKey();
            boolean emailSent = this.sendEmail(recipientInfo, messageText = this.composeMessage(incidents = (List)entry.getValue()));
            if (emailSent) continue;
            success = false;
        }
        return success;
    }

    public String composeMessage(List<IncidentInformation> incidents) {
        StringBuilder incidentDescriptions = new StringBuilder();
        for (IncidentInformation curIncident : incidents) {
            incidentDescriptions.append(this.composeIncidentDescription(curIncident));
            incidentDescriptions.append("\n");
        }
        return this.config.mailBodyTemplate().replaceAll("@INCIDENTS", incidentDescriptions.toString());
    }

    private String composeIncidentDescription(IncidentInformation incident) {
        String incidentText = this.config.incidentTemplate();
        incidentText = incidentText.replaceAll("@ACTIVITY", incident.activityId());
        incidentText = incidentText.replaceAll("@PROCESS_INSTANCE_ID", incident.processInstanceId());
        incidentText = incidentText.replaceAll("@MESSAGE", incident.message());
        incidentText = incidentText.replaceAll("@INCIDENT_TYPE", incident.type());
        incidentText = incidentText.replaceAll("@URL", String.format("%s/%s", this.config.url(), incident.processInstanceId()));
        incidentText = incidentText.replaceAll("@TIME", incident.time());
        return incidentText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendEmail(RecipientInfo recipientInfo, String messageText) {
        Properties mailConfig = new Properties();
        SMTPTransport transport = null;
        mailConfig.put("mail.debug", Boolean.toString(this.config.debug()));
        switch (this.config.protocol()) {
            case "smtp": {
                mailConfig.put("mail.smtp.host", this.config.host());
                if (StringUtils.hasLength((String)this.config.trust())) {
                    mailConfig.put("mail.smtp.ssl.trust", this.config.trust());
                }
                mailConfig.put("mail.smtp.auth", Boolean.toString(this.config.auth()));
                mailConfig.put("mail.smtp.port", Integer.toString(this.config.port()));
                mailConfig.put("mail.smtp.ssl.enable", Boolean.toString(this.config.ssl()));
                mailConfig.put("mail.smtp.starttls.enable", Boolean.toString(this.config.tls()));
                mailConfig.put("mail.smtp.connectiontimeout", Integer.toString(this.config.connectionTimeout()));
                mailConfig.put("mail.smtp.timeout", Integer.toString(this.config.timeout()));
                mailConfig.put("mail.smtp.writetimeout", Integer.toString(this.config.writeTimeout()));
                break;
            }
            case "smtps": {
                mailConfig.put("mail.smtps.host", this.config.host());
                mailConfig.put("mail.smtps.ssl.trust", this.config.trust());
                mailConfig.put("mail.smtps.auth", Boolean.toString(this.config.auth()));
                mailConfig.put("mail.smtps.port", Integer.toString(this.config.port()));
                mailConfig.put("mail.smtps.connectiontimeout", Integer.toString(this.config.connectionTimeout()));
                mailConfig.put("mail.smtps.timeout", Integer.toString(this.config.timeout()));
                mailConfig.put("mail.smtps.writetimeout", Integer.toString(this.config.writeTimeout()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported protocol: " + this.config.protocol());
            }
        }
        Session session = Session.getInstance((Properties)mailConfig, null);
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(this.config.mailSender()));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.determineReceiver(recipientInfo), (boolean)false));
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)recipientInfo.cc())) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)recipientInfo.cc(), (boolean)false));
            }
            msg.setSubject(this.config.subject());
            msg.setText(messageText);
            transport = (SMTPTransport)this.getTransport(session);
            transport.connect(this.config.host(), this.config.username(), this.config.password());
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            String response = transport.getLastServerResponse();
            LOGGER.info("Received response from server: '{}'", (Object)response);
            boolean bl = true;
            return bl;
        }
        catch (MessagingException exception) {
            LOGGER.error("An error occurred, while sending incident report: '{}'", (Object)messageText, (Object)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException exception) {
                    LOGGER.error("An error occurred, while sending incident report: '{}'", (Object)messageText, (Object)exception);
                }
            }
        }
    }

    public Transport getTransport(Session session) throws NoSuchProviderException {
        return switch (this.config.protocol()) {
            case "smtp" -> session.getTransport("smtp");
            case "smtps" -> session.getTransport("smtps");
            default -> throw new IllegalArgumentException("Unsupported protocol: " + this.config.protocol());
        };
    }

    public String determineReceiver(RecipientInfo recipientInfo) {
        String receiver = recipientInfo.receiver();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)receiver)) {
            receiver = this.config.fallbackMailReceiver();
            LOGGER.info("Using fallback receiver information {} because the process-related receiver is blank", (Object)receiver);
        }
        return receiver;
    }

    @Generated
    public EmailIncidentNotificationConfigurationProperty getConfig() {
        return this.config;
    }

    @Generated
    public ITimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @Generated
    public List<IncidentInformation> getIncidentInfos() {
        return this.incidentInfos;
    }

    @Generated
    public void setIncidentInfos(List<IncidentInformation> incidentInfos) {
        this.incidentInfos = incidentInfos;
    }
}

