/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.emailincidentnotification.plugin;

import com.eorion.bo.enhancement.emailincidentnotification.config.EmailIncidentNotificationConfigurationProperty;
import com.eorion.bo.enhancement.emailincidentnotification.handler.BufferingIncidentHandler;
import com.eorion.bo.enhancement.emailincidentnotification.handler.FailedExternalTaskIncidentHandler;
import com.eorion.bo.enhancement.emailincidentnotification.handler.FailedJobIncidentHandler;
import java.util.Arrays;
import java.util.List;
import org.camunda.bpm.engine.impl.cfg.AbstractProcessEnginePlugin;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailIncidentNotificationHandlerPlugin
extends AbstractProcessEnginePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailIncidentNotificationHandlerPlugin.class);
    private final EmailIncidentNotificationConfigurationProperty property;

    public EmailIncidentNotificationHandlerPlugin(EmailIncidentNotificationConfigurationProperty property) {
        this.property = property;
    }

    public void preInit(ProcessEngineConfigurationImpl processEngineConfig) {
        FailedJobIncidentHandler failedJobHandler = this.createFailedJobIncidentHandler();
        FailedExternalTaskIncidentHandler failedExternalTaskHandler = this.createFailedExternalTaskIncidentHandler();
        List<IncidentHandler> incidentListeners = Arrays.asList(new IncidentHandler[]{failedJobHandler, failedExternalTaskHandler});
        processEngineConfig.setCustomIncidentHandlers(incidentListeners);
        incidentListeners.stream().map(incidentHandler -> (BufferingIncidentHandler)((Object)incidentHandler)).forEach(BufferingIncidentHandler::startTimer);
        LOGGER.debug("EmailIncidentNotificationHandlerPlugin initialized.");
    }

    public FailedExternalTaskIncidentHandler createFailedExternalTaskIncidentHandler() {
        return new FailedExternalTaskIncidentHandler(this.property);
    }

    public FailedJobIncidentHandler createFailedJobIncidentHandler() {
        return new FailedJobIncidentHandler(this.property);
    }
}

