/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.externallauncher.adapter.inbound;

import com.eorion.bo.enhancement.externallauncher.domain.OpenProcessDefinitionDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenProcessInstanceDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenStartProcessInstanceDto;
import com.eorion.bo.enhancement.externallauncher.service.OpenProcessStartService;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enhancement/open"})
public class OpenProcessStartController {
    private final OpenProcessStartService service;

    public OpenProcessStartController(OpenProcessStartService service) {
        this.service = service;
    }

    @GetMapping(value={"/process-definition/{id}"})
    public ResponseEntity<OpenProcessDefinitionDto> getDetailByProcessDefinitionId(@PathVariable(value="id") String id) {
        return this.service.getDetailByProcessDefinitionId(id);
    }

    @GetMapping(value={"/process-definition/key/{key}"})
    public ResponseEntity<OpenProcessDefinitionDto> getDetailByProcessDefinitionKey(@PathVariable(value="key") String key) {
        return this.service.getDetailByProcessDefinitionKey(key);
    }

    @PostMapping(value={"/process-definition/{id}/submit-form"})
    public ResponseEntity<?> submitFormByProcessDefinitionId(@PathVariable(value="id") String id, @RequestBody OpenStartProcessInstanceDto startProcessInstanceDto) {
        return this.service.submitFormByProcessDefinitionId(id, startProcessInstanceDto);
    }

    @PostMapping(value={"/process-definition/key/{key}/submit-form"})
    public ResponseEntity<OpenProcessInstanceDto> submitFormByProcessDefinitionKey(@PathVariable(value="key") String key, @RequestBody OpenStartProcessInstanceDto startProcessInstanceDto) {
        return this.service.submitFormByProcessDefinitionKey(key, startProcessInstanceDto);
    }
}

