/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.externallauncher.service;

import com.eorion.bo.enhancement.externallauncher.domain.FormDetailDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenProcessDefinitionDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenProcessInstanceDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenStartProcessInstanceDto;
import com.eorion.bo.enhancement.externallauncher.service.ExternalFormService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.impl.instance.ProcessImpl;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpenProcessStartService {
    private static final Logger log = LoggerFactory.getLogger(OpenProcessStartService.class);
    private static final String PUBLIC_ACCESS_ENABLED = "publicAccessEnabled";
    private static final String PUBLIC_ACCESS_ENABLED_FLAG = "true";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RepositoryService repositoryService;
    private final FormService formService;
    private final ExternalFormService externalFormService;
    private final ProcessEngine processEngine;

    public OpenProcessStartService(RepositoryService repositoryService, FormService formService, ExternalFormService externalFormService, ProcessEngine processEngine) {
        this.repositoryService = repositoryService;
        this.formService = formService;
        this.externalFormService = externalFormService;
        this.processEngine = processEngine;
    }

    protected boolean publicAccessEnabledByProcessDefinitionKey(String key) {
        if (!StringUtils.hasLength((String)key)) {
            return false;
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
        if (Objects.isNull(definition)) {
            return false;
        }
        BpmnModelInstance bpmnModelInstance = this.repositoryService.getBpmnModelInstance(definition.getId());
        if (Objects.isNull(bpmnModelInstance)) {
            return false;
        }
        ProcessImpl parallelGatewayTest = (ProcessImpl)bpmnModelInstance.getModelElementById(definition.getKey());
        CamundaProperties camundaProperties = (CamundaProperties)parallelGatewayTest.getExtensionElements().getElementsQuery().filterByType(CamundaProperties.class).singleResult();
        for (CamundaProperty camundaProperty : camundaProperties.getCamundaProperties()) {
            String name = camundaProperty.getCamundaName();
            String value = camundaProperty.getCamundaValue();
            if (!PUBLIC_ACCESS_ENABLED.equals(name) || !PUBLIC_ACCESS_ENABLED_FLAG.equals(value)) continue;
            return true;
        }
        return false;
    }

    protected boolean publicAccessEnabledByProcessDefinitionId(String id) {
        if (!StringUtils.hasLength((String)id)) {
            return false;
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (Objects.isNull(definition)) {
            return false;
        }
        InputStream processModelInputStream = this.repositoryService.getProcessModel(definition.getId());
        if (processModelInputStream != null) {
            Document document;
            try {
                document = DocumentHelper.parseText((String)new String(processModelInputStream.readAllBytes()));
            }
            catch (IOException | DocumentException e) {
                throw new RuntimeException(e);
            }
            XPath xpath = document.createXPath("/bpmn:definitions/bpmn:process/bpmn:extensionElements/camunda:properties/camunda:property");
            List nodeList = xpath.selectNodes((Object)document);
            if (nodeList != null && !nodeList.isEmpty()) {
                for (Node node : nodeList) {
                    Element element1 = (Element)node;
                    String value = element1.attributeValue("value");
                    String name = element1.attributeValue("name");
                    if (!PUBLIC_ACCESS_ENABLED.equals(name) || !PUBLIC_ACCESS_ENABLED_FLAG.equals(value)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public ResponseEntity<OpenProcessDefinitionDto> getDetailByProcessDefinitionId(String id) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (Objects.isNull(processDefinition)) {
            return ResponseEntity.notFound().build();
        }
        boolean publicAccessEnabled = this.publicAccessEnabledByProcessDefinitionId(processDefinition.getId());
        if (!publicAccessEnabled) {
            return ResponseEntity.notFound().build();
        }
        String startFormKey = this.formService.getStartFormKey(processDefinition.getId());
        OpenProcessDefinitionDto openProcessDefinitionDto = OpenProcessDefinitionDto.fromProcessDefinition(processDefinition);
        if (!StringUtils.hasLength((String)startFormKey)) {
            return ResponseEntity.ok((Object)openProcessDefinitionDto);
        }
        FormDetailDto fromDetail = this.externalFormService.getFromDetailById(startFormKey);
        if (Objects.isNull(fromDetail)) {
            return ResponseEntity.ok((Object)openProcessDefinitionDto);
        }
        openProcessDefinitionDto.setFormId(fromDetail.getId());
        if (Objects.nonNull(fromDetail.getFromData())) {
            Object formData;
            try {
                formData = this.objectMapper.readValue(fromDetail.getFromData(), Object.class);
            }
            catch (JsonProcessingException e) {
                log.error("", (Throwable)e);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
            openProcessDefinitionDto.setFormData(formData);
        }
        return ResponseEntity.ok((Object)openProcessDefinitionDto);
    }

    public ResponseEntity<OpenProcessDefinitionDto> getDetailByProcessDefinitionKey(String key) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
        if (Objects.isNull(processDefinition)) {
            return ResponseEntity.notFound().build();
        }
        boolean publicAccessEnabled = this.publicAccessEnabledByProcessDefinitionId(processDefinition.getId());
        if (!publicAccessEnabled) {
            return ResponseEntity.notFound().build();
        }
        String startFormKey = this.formService.getStartFormKey(processDefinition.getId());
        OpenProcessDefinitionDto openProcessDefinitionDto = OpenProcessDefinitionDto.fromProcessDefinition(processDefinition);
        if (!StringUtils.hasLength((String)startFormKey)) {
            return ResponseEntity.ok((Object)openProcessDefinitionDto);
        }
        FormDetailDto fromDetail = this.externalFormService.getFromDetailById(startFormKey);
        if (Objects.isNull(fromDetail)) {
            return ResponseEntity.ok((Object)openProcessDefinitionDto);
        }
        openProcessDefinitionDto.setFormId(fromDetail.getId());
        if (Objects.nonNull(fromDetail.getFromData())) {
            Object formData;
            try {
                formData = this.objectMapper.readValue(fromDetail.getFromData(), Object.class);
            }
            catch (JsonProcessingException e) {
                log.error("", (Throwable)e);
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
            }
            openProcessDefinitionDto.setFormData(formData);
        }
        return ResponseEntity.ok((Object)openProcessDefinitionDto);
    }

    public ResponseEntity<?> submitFormByProcessDefinitionId(String id, OpenStartProcessInstanceDto startProcessInstanceDto) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(id).singleResult();
        if (Objects.isNull(processDefinition)) {
            return ResponseEntity.notFound().build();
        }
        boolean enabled = this.publicAccessEnabledByProcessDefinitionId(processDefinition.getId());
        if (!enabled) {
            return ResponseEntity.notFound().build();
        }
        if (Objects.nonNull(startProcessInstanceDto)) {
            VariableMap variableMap;
            String businessKey = startProcessInstanceDto.getBusinessKey();
            Map<String, VariableValueDto> variables = startProcessInstanceDto.getVariables();
            try {
                variableMap = VariableValueDto.toMap(variables, (ProcessEngine)this.processEngine, (ObjectMapper)this.objectMapper);
            }
            catch (Exception e) {
                log.error("VariableValue to map error: {}", (Object)e.getMessage());
                return ResponseEntity.badRequest().body((Object)"Variable is not Correct \uff01");
            }
            ProcessInstance processInstance = StringUtils.hasLength((String)businessKey) ? this.formService.submitStartForm(processDefinition.getId(), businessKey, (Map)variableMap) : this.formService.submitStartForm(processDefinition.getId(), (Map)variableMap);
            if (processInstance != null) {
                return ResponseEntity.ok((Object)((Object)OpenProcessInstanceDto.fromProcessInstance(processInstance)));
            }
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    public ResponseEntity<OpenProcessInstanceDto> submitFormByProcessDefinitionKey(String key, OpenStartProcessInstanceDto startProcessInstanceDto) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(key).latestVersion().singleResult();
        if (Objects.isNull(processDefinition)) {
            return ResponseEntity.notFound().build();
        }
        boolean enabled = this.publicAccessEnabledByProcessDefinitionId(processDefinition.getId());
        if (!enabled) {
            return ResponseEntity.notFound().build();
        }
        if (Objects.nonNull(startProcessInstanceDto)) {
            String businessKey = startProcessInstanceDto.getBusinessKey();
            Map<String, VariableValueDto> variables = startProcessInstanceDto.getVariables();
            VariableMap variableMap = VariableValueDto.toMap(variables, (ProcessEngine)this.processEngine, (ObjectMapper)this.objectMapper);
            ProcessInstance processInstance = StringUtils.hasLength((String)businessKey) ? this.formService.submitStartForm(processDefinition.getId(), businessKey, (Map)variableMap) : this.formService.submitStartForm(processDefinition.getId(), (Map)variableMap);
            if (processInstance != null) {
                return ResponseEntity.ok((Object)((Object)OpenProcessInstanceDto.fromProcessInstance(processInstance)));
            }
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
    }
}

