/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.externallauncher.service;

import com.eorion.bo.enhancement.externallauncher.domain.FormDetailDto;
import com.eorion.bo.enhancement.externallauncher.domain.OpenTaskDto;
import com.eorion.bo.enhancement.externallauncher.service.ExternalFormService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.task.CompleteTaskDto;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.variable.VariableMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OpenUserTaskService {
    private static final Logger log = LoggerFactory.getLogger(OpenUserTaskService.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RepositoryService repositoryService;
    private final TaskService taskService;
    private final ExternalFormService externalFormService;
    private final FormService formService;
    private final ProcessEngine processEngine;

    public OpenUserTaskService(RepositoryService repositoryService, TaskService taskService, ExternalFormService externalFormService, FormService formService, ProcessEngine processEngine) {
        this.repositoryService = repositoryService;
        this.taskService = taskService;
        this.externalFormService = externalFormService;
        this.formService = formService;
        this.processEngine = processEngine;
    }

    public ResponseEntity<?> getTaskInfoById(String id) {
        String activityId;
        String processDefinitionId;
        boolean enabled;
        TaskEntity task = (TaskEntity)this.taskService.createTaskQuery().taskId(id).singleResult();
        if (task != null && (enabled = this.publicAccessEnabledByProcessDefinitionIdAndActivityId(processDefinitionId = task.getProcessDefinitionId(), activityId = task.getTaskDefinitionKey()))) {
            OpenTaskDto openTaskDto = OpenTaskDto.fromEntity((Task)task);
            String formKey = this.formService.getTaskFormKey(processDefinitionId, activityId);
            if (StringUtils.hasLength((String)formKey)) {
                openTaskDto.setFormKey(formKey);
                FormDetailDto fromDetailById = this.externalFormService.getFromDetailById(formKey);
                if (fromDetailById != null) {
                    String fromData = fromDetailById.getFromData();
                    Object ObjFormData = null;
                    try {
                        ObjFormData = this.objectMapper.readValue(fromData, Object.class);
                    }
                    catch (JsonProcessingException e) {
                        log.error("", (Throwable)e);
                        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).build();
                    }
                    openTaskDto.setFormData(ObjFormData);
                }
            }
            return ResponseEntity.ok((Object)openTaskDto);
        }
        return ResponseEntity.notFound().build();
    }

    public ResponseEntity<?> submitFormTask(String id, CompleteTaskDto completeTaskDto) {
        String activityId;
        String processDefinitionId;
        boolean enabled;
        Task task = (Task)this.taskService.createTaskQuery().taskId(id).singleResult();
        if (task != null && (enabled = this.publicAccessEnabledByProcessDefinitionIdAndActivityId(processDefinitionId = task.getProcessDefinitionId(), activityId = task.getTaskDefinitionKey())) && completeTaskDto.getVariables() != null && !completeTaskDto.getVariables().isEmpty()) {
            VariableMap variableMap;
            Map variables = completeTaskDto.getVariables();
            try {
                variableMap = VariableValueDto.toMap((Map)variables, (ProcessEngine)this.processEngine, (ObjectMapper)this.objectMapper);
            }
            catch (Exception e) {
                log.error("VariableValue to map error: {}", (Object)e.getMessage());
                return ResponseEntity.badRequest().body((Object)"Variable is not Correct \uff01");
            }
            if (variableMap != null && !variables.isEmpty()) {
                this.formService.submitTaskForm(task.getId(), (Map)variableMap);
            }
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }

    protected boolean publicAccessEnabledByProcessDefinitionIdAndActivityId(String processDefinitionId, String activityId) {
        if (!StringUtils.hasLength((String)processDefinitionId) || !StringUtils.hasLength((String)activityId)) {
            return false;
        }
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (Objects.isNull(definition)) {
            return false;
        }
        InputStream processModelInputStream = this.repositoryService.getProcessModel(definition.getId());
        if (processModelInputStream != null) {
            Document document;
            try {
                document = DocumentHelper.parseText((String)new String(processModelInputStream.readAllBytes()));
            }
            catch (IOException | DocumentException e) {
                throw new RuntimeException(e);
            }
            String xpathStr = "/bpmn:definitions/bpmn:process/bpmn:userTask[@id=\"" + activityId + "\"]/bpmn:extensionElements/camunda:properties/camunda:property[@name=\"externalAccessEnable\" and @value=\"true\"]";
            XPath xpath = document.createXPath(xpathStr);
            List nodes = xpath.selectNodes((Object)document, xpath);
            return nodes != null && !nodes.isEmpty();
        }
        return false;
    }
}

