/*
 * Decompiled with CFR 0.152.
 */
package com.eorion.bo.enhancement.processdraft.adapter.inbound;

import com.eorion.bo.enhancement.processdraft.domain.commom.PageInfo;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftQueryDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftSaveDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.inbound.ProcessDraftUpdateDTO;
import com.eorion.bo.enhancement.processdraft.domain.dto.outbound.IdDTO;
import com.eorion.bo.enhancement.processdraft.domain.exception.DataNotExistException;
import com.eorion.bo.enhancement.processdraft.domain.exception.InsertFailedException;
import com.eorion.bo.enhancement.processdraft.service.ProcessDraftService;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/enhancement/draft"})
public class ProcessDraftController {
    private final ProcessDraftService draftService;

    @PostMapping
    public IdDTO<Integer> saveProcessDraft(@RequestBody ProcessDraftSaveDTO saveDTO) throws InsertFailedException {
        return this.draftService.saveProcessDraft(saveDTO);
    }

    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updatedProcessDraft(@PathVariable Integer id, @RequestBody ProcessDraftUpdateDTO updateDTO) throws DataNotExistException {
        this.draftService.updatedProcessDraft(id, updateDTO);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteProcessDraft(@PathVariable Integer id) {
        this.draftService.deleteProcessDraft(id);
    }

    @PostMapping(value={"/list"})
    public PageInfo<?> getProcessDraftPageList(@RequestParam(value="firstResult", required=false, defaultValue="0") Integer firstResult, @RequestParam(value="maxResults", required=false, defaultValue="2147483647") Integer maxResults, @RequestBody(required=false) ProcessDraftQueryDTO queryDTO) {
        return this.draftService.getProcessDraftPageList(firstResult, maxResults, queryDTO);
    }

    @Generated
    public ProcessDraftController(ProcessDraftService draftService) {
        this.draftService = draftService;
    }
}

